﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nnt/nntest.h>

#include "../Common/testBle_Common.h"
#include "../Common/testBle_ConnectCommon.h"

#include <nn/bluetooth/bluetooth_LeApi.h>

//!< Radio On 中、接続せずに結果を取得した場合、結果の数は 0
TEST(TestBleConnect, GetStateWithoutConnection)
{
    nnt::bluetooth::common::SetUp();
    nnt::bluetooth::connect::SetUp();

    nn::bluetooth::BleConnectionInfo connectionInfo[nn::bluetooth::BleConnectionCountMaxClient];

    int connectionCount = nn::bluetooth::GetBleConnectionInfoList(connectionInfo, NN_ARRAY_SIZE(connectionInfo));

    EXPECT_EQ(connectionCount, 0);

    for (const auto& info : connectionInfo)
    {
        EXPECT_EQ(info.connectionHandle, nn::bluetooth::BleInvalidConnectionHandle);
    }

    nnt::bluetooth::common::TearDown();
    nnt::bluetooth::connect::TearDown();
}

//!< Radio Off 中、接続せずに結果を取得した場合、結果の数は 0
TEST(TestBleConnect, GetStateWithoutConnectionRadioOff)
{
    nnt::bluetooth::common::SetUp();
    nnt::bluetooth::connect::SetUp();

    nnt::bluetooth::common::EnableRadio(false);

    nn::bluetooth::BleConnectionInfo connectionInfo[nn::bluetooth::BleConnectionCountMaxClient];

    int connectionCount = nn::bluetooth::GetBleConnectionInfoList(connectionInfo, NN_ARRAY_SIZE(connectionInfo));

    EXPECT_EQ(connectionCount, 0);

    for (const auto& info : connectionInfo)
    {
        EXPECT_EQ(info.connectionHandle, nn::bluetooth::BleInvalidConnectionHandle);
    }

    nnt::bluetooth::common::TearDown();
    nnt::bluetooth::connect::TearDown();
}

//!< Radio On 中、接続していない状態で、Disconnect しようとすると、nn::bluetooth::ResultBleNotConnected()
TEST(TestBleConnect, DisconnectWithoutConnection)
{
    nnt::bluetooth::common::SetUp();
    nnt::bluetooth::connect::SetUp();

    nn::bluetooth::BleConnectionInfo connectionInfo[nn::bluetooth::BleConnectionCountMaxClient];

    int connectionCount = nn::bluetooth::GetBleConnectionInfoList(connectionInfo, NN_ARRAY_SIZE(connectionInfo));
    EXPECT_EQ(connectionCount, 0);

    for (const auto& info : connectionInfo)
    {
        EXPECT_EQ(info.connectionHandle, nn::bluetooth::BleInvalidConnectionHandle);
    }

    // 先頭の接続ハンドル（nn::bluetooth::BleInvalidConnectionHandle）に対しDisconnect する
    auto result = nn::bluetooth::DisconnectFromGattServer(connectionInfo[0].connectionHandle);

    EXPECT_TRUE(nn::bluetooth::ResultBleNotConnected().Includes(result));

    nnt::bluetooth::common::TearDown();
    nnt::bluetooth::connect::TearDown();
}

//!< Radio Off 中、接続していない状態で、Disconnect しようとすると、nn::bluetooth::ResultBleNotConnected()
TEST(TestBleConnect, DisconnectWithoutConnectionRadiOff)
{
    nnt::bluetooth::common::SetUp();
    nnt::bluetooth::connect::SetUp();

    nn::bluetooth::BleConnectionInfo connectionInfo[nn::bluetooth::BleConnectionCountMaxClient];

    int connectionCount = nn::bluetooth::GetBleConnectionInfoList(connectionInfo, NN_ARRAY_SIZE(connectionInfo));
    EXPECT_EQ(connectionCount, 0);

    for (const auto& info : connectionInfo)
    {
        EXPECT_EQ(info.connectionHandle, nn::bluetooth::BleInvalidConnectionHandle);
    }

    // 先頭の接続ハンドル（nn::bluetooth::BleInvalidConnectionHandle）に対しDisconnect する
    auto result = nn::bluetooth::DisconnectFromGattServer(connectionInfo[0].connectionHandle);

    EXPECT_TRUE(nn::bluetooth::ResultBleNotConnected().Includes(result));

    nnt::bluetooth::common::TearDown();
    nnt::bluetooth::connect::TearDown();
}

