﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nnt/nntest.h>

namespace nnt { namespace bluetooth { namespace scan {
    /**
     * @brief           テスト全体を末期化します
     *
     * @details         テスト終了時に 1 度だけ呼んでください
     */
    void Finalize();

    /**
     * @brief           各テストの開始処理を行います
     *
     * @details         各テストの開始時に呼んでください。
     *                  以下の処理を行います。
     *                  - BLE Scan の停止
     *                  - BLE Scan イベントをハンドリングするスレッドの開始
     *
     * @param[in]       pScanEvent                  BLE Scan イベント発生時にシグナルされるイベントオブジェクトへのポインタ
     *
     * @pre
     *                  - pScanEvent != nullptr ならば、pScanEvent は初期化済み
     */
    void SetUp(nn::os::EventType *pScanEvent = nullptr);

    /**
     * @brief           各テストの終了処理を行います
     *
     * @details         各テストの終了時に呼んでください。
     *                  以下の処理を行います。
     *                  - BLE Scan の停止
     *                  - BLE Scan イベントをハンドリングするスレッドの停止
     */
    void TearDown();


    const nn::bluetooth::GattAttributeUuid testPeripheralAdvUuid =
    {
        .length = nn::bluetooth::GattAttributeUuidLength_128,
        .uu.uuid128 = { 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF, 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99 }
    };
}}};    // namespace nnt::bluetooth::scan
