﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testBcat_Common.h"

#include <nn/bcat/detail/service/core/bcat_PushNotificationLogManager.h>

using namespace nn::bcat::detail::service::core;

TEST(PushNotificationLogManager, Test1)
{
    nn::bcat::detail::TopicId topicId = {"nx_data_0000000000000001"};

    PushNotificationLogManager::GetInstance().Notify(topicId);

    static nn::bcat::PushNotificationLog s_Logs[nn::bcat::PushNotificationLogCountMax] = {};
    int count = 0;

    PushNotificationLogManager::GetInstance().GetList(&count, s_Logs, NN_ARRAY_SIZE(s_Logs));

    EXPECT_TRUE(count == 1);
    EXPECT_TRUE(s_Logs[0].appId.value == 0x0000000000000001ull);
}

TEST(PushNotificationLogManager, Test2)
{
    for (int i = 0; i < 1000; i++)
    {
        nn::bcat::detail::TopicId topicId = {};
        nn::util::SNPrintf(topicId.value, sizeof (topicId.value), "nx_data_%016llx", static_cast<nn::Bit64>(i + 1));

        PushNotificationLogManager::GetInstance().Notify(topicId);

        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(10));
    }

    static nn::bcat::PushNotificationLog s_Logs[nn::bcat::PushNotificationLogCountMax] = {};
    int count = 0;

    PushNotificationLogManager::GetInstance().GetList(&count, s_Logs, NN_ARRAY_SIZE(s_Logs));

    EXPECT_TRUE(count == nn::bcat::PushNotificationLogCountMax);

    nn::time::PosixTime prevTime = {};

    for (int i = 0; i < count; i++)
    {
        nn::ApplicationId appId = {static_cast<nn::Bit64>(1000 - i)};

        // 最近登録した順に取得できる。
        EXPECT_TRUE(s_Logs[i].appId == appId);

        if (i > 0)
        {
            EXPECT_TRUE(s_Logs[i].receivedTime <= prevTime);
        }

        prevTime = s_Logs[i].receivedTime;
    }
}
