﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/os.h>
#include <nn/ae.h>
#include <nn/applet/applet.h>
#include <cstdarg>
#include "applet_Configs.h"

void ProcessMessage(const char* pKind, nn::ae::Message message) NN_NOEXCEPT;
void PrintAppletMessage(const char* pKind, nn::ae::Message message) NN_NOEXCEPT;
bool CheckAndProcessMessageImpl(const char* pKind, nn::os::SystemEventType* pEvent, nn::ae::Message expectMessage) NN_NOEXCEPT;
bool WaitForAllMessageArrivedImpl(const char* pKind, nn::os::SystemEventType* pEvent, ...) NN_NOEXCEPT;

void DumpMemory(const char* pKind, const char* buffer) NN_NOEXCEPT;
void FillMemory(char* buffer, size_t size, char seed) NN_NOEXCEPT;
void CheckMemory(const char* buffer, size_t size, char seed) NN_NOEXCEPT;

#define CheckAndProcessMessage(pKind, pEvent, expected)    \
        NN_ABORT_UNLESS(CheckAndProcessMessageImpl(pKind, pEvent, expected), " at line:%d", __LINE__)


#define WaitForAllMessageArrived(pKind, pEvent, ...) \
        NN_ABORT_UNLESS(WaitForAllMessageArrivedImpl(pKind, pEvent, __VA_ARGS__, -1), " at line:%d", __LINE__)
