﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/nn_Common.h>
#include <nn/oe.h>
#include "../testOe_LaunchParameter.h"

namespace
{
    char g_ParameterBuffer[nnt::oe::LaunchParameterSizeMax + 1];
    char g_ExpectedArguments[] = "normal size arguments.";
}

TEST(LaunchParam, NormalSizeParameter)
{
    size_t realParameterSize;
    ASSERT_TRUE(nn::oe::TryPopLaunchParameter(&realParameterSize, g_ParameterBuffer, sizeof(g_ParameterBuffer)));
    ASSERT_LT(realParameterSize, sizeof(g_ParameterBuffer));
    EXPECT_EQ(sizeof(g_ExpectedArguments) - 1, realParameterSize);
    g_ParameterBuffer[realParameterSize] = '\0';
    EXPECT_STREQ(g_ExpectedArguments, g_ParameterBuffer);
}
