﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <string>
#include <nn/vi/vi_Layer.h>

namespace Graphics {

struct Rgba
{
    float r;
    float g;
    float b;
    float a;
};

void InitializeGraphics( Rgba clearColor, std::string title ) NN_NOEXCEPT;

nn::vi::Layer* GetViLayer() NN_NOEXCEPT;

void SetMessage( const char* pMessage ) NN_NOEXCEPT;

void SetAudioStatus(bool isEnable) NN_NOEXCEPT;

void GraphicsRenderer() NN_NOEXCEPT;

void WaitVsync() NN_NOEXCEPT;

void SetWaitPressHomeButtonMode() NN_NOEXCEPT;

void FinalizeGraphics() NN_NOEXCEPT;

} // Graphics
