﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/vi/vi_Layer.h>

namespace Graphics {

struct Rgba
{
    float r;
    float g;
    float b;
    float a;
};

void InitializeGraphics( Rgba clearColor, std::string title );

nn::vi::Layer* GetViLayer();
nn::vi::Display* GetViDisplay();

int GetObjectCount();
void SetObjectCount(int objectCount);
int GetLiteObjectCount();
void SetLiteObjectCount(int objectCount);

int GetSleepCount();
void SetSleepCount(int sleepCount);

bool GetClearEnabled();
void SetClearEnabled(bool enabled);

void SetWaitPressHomeButtonMode();

void GraphicsRenderer(bool isPrepareSuspend);

void FinalizeGraphics();

} // Graphics
