#!/bin/bash

#SDK_ROOT="c:/home/SIGLO/sdk"
SDK_ROOT=$NINTENDO_SDK_ROOT

DEVMENUCMDSYS="$SDK_ROOT/Programs/Eris/Outputs/NX-NXFP2-a64/TargetTools/DevMenuCommandSystem/Release/DevMenuCommandSystem.nsp"
DEVMENUCMD="$SDK_ROOT/Programs/Eris/Outputs/NX-NXFP2-a64/TargetTools/DevMenuCommand/Release/DevMenuCommand.nsp"

RUNONTARGET="$SDK_ROOT/Tools/CommandLineTools/RunOnTarget.exe"
PROJECT_PATH="$SDK_ROOT/Tests/Outputs/NX-NXFP2-a64/Tests"

#------------------------------------------------------------------------------

function InstallApplication() {
    NSP="$PROJECT_PATH/$1/Develop/$1.nsp"
    PROGRAM_ID=$2

    $RUNONTARGET $DEVMENUCMD application uninstall $PROGRAM_ID > /dev/null
    $RUNONTARGET $DEVMENUCMD application install $NSP
}

function InstallSystem() {
    NSP="$PROJECT_PATH/$1/Develop/$1.nsp"
    PROGRAM_ID=$2

    $RUNONTARGET $DEVMENUCMDSYS systemprogram uninstall $PROGRAM_ID > /dev/null
    $RUNONTARGET $DEVMENUCMDSYS systemprogram install $NSP
}

function SelectSystemApplet() {
    PROGRAM_ID=$1
    $RUNONTARGET $DEVMENUCMDSYS -- systemprogram set-initial-system-applet-program $PROGRAM_ID
}

function SelectOverlayApplet() {
    PROGRAM_ID=$1
    $RUNONTARGET $DEVMENUCMDSYS -- systemprogram set-overlay-disp-program $PROGRAM_ID
}

#------------------------------------------------------------------------------

InstallApplication AppletIApp   0x0100008003486000
InstallSystem      AppletISA    0x0100000000001000
InstallSystem      AppletIOA    0x010000000000100C
InstallSystem      AppletILA1   0x0100000000001001
InstallSystem      AppletILA2   0x0100000000001002
InstallSystem      AppletISTA   0x0100000000001012

SelectSystemApplet  0x0100000000001000
SelectOverlayApplet 0x010000000000100C

