﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

namespace nnt { namespace applet { namespace audioout {

    enum Bgm
    {
        Bgm_A,
        Bgm_B
    };

    enum Se
    {
        Se_A,
        Se_B,
        Se_C,
        Se_D
    };

    enum Sine
    {
        Sine_Disabled,
        Sine_Mario,
        Sine_Kart
    };

    void InitializeAudio() NN_NOEXCEPT;
    void FinalizeAudio() NN_NOEXCEPT;

    void WaitAudio() NN_NOEXCEPT;
    void UpdateAudio() NN_NOEXCEPT;

    void LoadBgm( Bgm bgm ) NN_NOEXCEPT;
    void PlayBgm() NN_NOEXCEPT;
    void PauseBgm() NN_NOEXCEPT;
    void PlaySine() NN_NOEXCEPT;
    void PauseSine() NN_NOEXCEPT;

    void PlaySe( Se se ) NN_NOEXCEPT;

}}} // nnt::applet::audioout
