﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       HW 評価ソフト向け汎用ライブラリの LCD 出力に関するヘッダファイル
 */
#pragma once

#include <nn/gfx/util/gfx_DebugFontTextWriter.h>

namespace nnt { namespace eval {

/**
 * @brief   LCD 出力を扱うためのクラスです。
 *
 * @details 本ライブラリを使用して文字出力を行うためには、
 *          アプリのリソースフォルダに以下の構成でフォントファイルを指定する必要があります。
 *          - [root]/fonts/nintendo_NTLG-DB_002_NX.bffnt"
 */
class Screen
{
public:
    /**
    * @brief   スクリーンオブジェクトを構築し初期化します。
    */
    void Initialize() NN_NOEXCEPT;
    /**
    * @brief   スクリーンオブジェクトを破棄します。
    *
    * @pre     @ref nnt::eval::Screen::Initialize() により初期化済みの状態である必要があります。
    *
    */
    void Finalize() NN_NOEXCEPT;
    /**
    * @brief   描画バッファを LCD に出力します。
    *
    * @pre     @ref nnt::eval::Screen::Initialize() により初期化済みの状態である必要があります。
    *
    */
    void Draw() NN_NOEXCEPT;
    /**
    * @brief   DebugFont の TextWriter オブジェクトを取得します。
    *
    * @pre     @ref nnt::eval::Screen::Initialize() により初期化済みの状態である必要があります。
    *
    * @return  DebugFont の TextWriter オブジェクトを返します。
    *
    */
    nn::gfx::util::DebugFontTextWriter* GetDebugFontTextWriter() NN_NOEXCEPT;
};

/**
 * @brief   色です。
 */
const nn::util::Unorm8x4 Black = { { 0x00, 0x00, 0x00, 0xFF } };
const nn::util::Unorm8x4 White = { { 0xFF, 0xFF, 0xFF, 0xFF } };
const nn::util::Unorm8x4 Gray = { { 0x80, 0x80, 0x80, 0xFF } };
const nn::util::Unorm8x4 Blue = { { 0x2B, 0x4E, 0x91, 0xFF } };
const nn::util::Unorm8x4 Red = { { 0xB5, 0x2F, 0x25, 0xFF } };
const nn::util::Unorm8x4 Yellow = { { 0xEB, 0xB1, 0x30, 0xFF } };
const nn::util::Unorm8x4 Green = { { 0x54, 0x9B, 0x2A, 0xFF } };
const nn::util::Unorm8x4 Purple = { { 0xAE, 0x48, 0x7B, 0xFF } };
const nn::util::Unorm8x4 LightBlue = { { 0x3E, 0x95, 0xBA, 0xFF } };


}} // namespace nnt::common

