﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Types.h>
#include <nn/nn_Common.h>

bool TestOpenClose() NN_NOEXCEPT;
bool TestRegistrationAsCommon(
    const int ExpectedCount = 0,
    const int ExpectedOpenCount = 0) NN_NOEXCEPT;
bool TestRegistrationAsWatcher() NN_NOEXCEPT;
bool TestRegistrationAsManager() NN_NOEXCEPT;

bool TestProfile() NN_NOEXCEPT;

bool TestNetworkServiceAccount(const nn::account::Uid& user) NN_NOEXCEPT;
bool TestNetworkServiceAccountFailure(const nn::account::Uid& user) NN_NOEXCEPT;

//TODO: テストアプリでも Application ID をとれるようになったら有効にする
// #define NNT_ACCOUNT_ENABLE_APPLICATION_TEST
