﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "baas/account_BaasResourceResolver.h"
#include <nn/account/detail/account_Settings.h>

#include <nn/nn_Abort.h>
#include <nn/fs/fs_Rom.h>
#include <nn/fs/fs_Mount.h>
#include <nn/util/util_ScopeExit.h>

#include "testAccount_Initializer.h"
#include <nnt.h>


extern "C" void nnMain()
{
    int result = 1;
    nnt::account::InitializeNetworkTest();
    NN_UTIL_SCOPE_EXIT {
        nnt::account::FinalizeNetworkTest(result);
    };

    // ROM のマウント
    size_t mountRomCacheBufferSize = 0;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::fs::QueryMountRomCacheSize(&mountRomCacheBufferSize));
    void* mountRomCacheBuffer = std::malloc(mountRomCacheBufferSize);
    NN_ABORT_UNLESS_NOT_NULL(mountRomCacheBuffer);
    NN_UTIL_SCOPE_EXIT
    {
        std::free(mountRomCacheBuffer);
    };

    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::fs::MountRom("rom", mountRomCacheBuffer, mountRomCacheBufferSize));
        NN_UTIL_SCOPE_EXIT
        {
            nn::fs::Unmount("rom");
        };

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
        // ファームウェア設定の読み込み
        nn::account::detail::FirmwareSettings::Refresh();
#endif

        // テストの実行
        result = RUN_ALL_TESTS();
    }
}


#if 0

#include <curl/curl.h>
#include <nn/nn_Log.h>
#include <nn/ssl/ssl_Context.h>

namespace
{
#define SET_CURLOPT(handle, opt, ...) \
    do \
    { \
        CURLcode _r = curl_easy_setopt(handle, opt, __VA_ARGS__); \
        if (_r != CURLE_OK) \
        { \
            NN_ABORT("curl_easy_setopt(" #opt ") failed (%d)\n", _r); \
        } \
    } while (NN_STATIC_CONDITION(false))

size_t DefaultSslCtxFunction(CURL* pCurl, void* pSslContext, void* pUserData) NN_NOEXCEPT
{
    NN_UNUSED(pCurl);
    NN_UNUSED(pUserData);

    auto& context = *reinterpret_cast<nn::ssl::Context*>(pSslContext);
    if (context.Create(nn::ssl::Context::SslVersion_Auto).IsFailure())
    {
        return static_cast<size_t>(- 1);
    }
    return 0;
}
void ExecHttpRequest(const char* url) NN_NOEXCEPT
{
    static const char Https[] = "https://";
    bool isHttps = (strncmp(url, Https, sizeof(Https) - 1) == 0);

    CURL *curl;
    CURLcode res;

    //curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();
    NN_ABORT_UNLESS(curl, "curl_easy_init() failed\n");

    /* basic */
    SET_CURLOPT(curl, CURLOPT_NOPROGRESS, 0L);
    SET_CURLOPT(curl, CURLOPT_VERBOSE, 1L);

    /* advance*/
    const long RedirectCountMax =  0L; // リダイレクトは 0 回まで
    const long LowSpeedLimit    =  1L; // 転送ビットレートは 1bps を下限とする
    const long LowSpeedTime     = 30L; // LowSpeedLimit が 30 秒つづくと通信を中断する
    const long ConnectTimeout   = 30L; // サーバとの接続(CONNECT)のタイムアウト (30秒)
    const long TimeoutSeconds   = 300L; // 通信全体でのタイムアウト (5分)
    SET_CURLOPT(curl, CURLOPT_FOLLOWLOCATION,   1L);
    SET_CURLOPT(curl, CURLOPT_MAXREDIRS,        RedirectCountMax);
    SET_CURLOPT(curl, CURLOPT_LOW_SPEED_LIMIT,  LowSpeedLimit);
    SET_CURLOPT(curl, CURLOPT_LOW_SPEED_TIME,   LowSpeedTime);
    SET_CURLOPT(curl, CURLOPT_CONNECTTIMEOUT,   ConnectTimeout);
    SET_CURLOPT(curl, CURLOPT_TIMEOUT,          TimeoutSeconds);
    SET_CURLOPT(curl, CURLOPT_SSL_VERIFYPEER,   0L); // server validation is disabled for testing
    SET_CURLOPT(curl, CURLOPT_SSL_VERIFYHOST,   0L); // host name validation is disabled for testing
#if defined(NN_BUILD_CONFIG_OS_WIN)
    SET_CURLOPT(curl, CURLOPT_PROXYAUTOCONFIG,  0);
    SET_CURLOPT(curl, CURLOPT_PROXYTYPE,        CURLPROXY_HTTP);
    SET_CURLOPT(curl, CURLOPT_HTTPPROXYTUNNEL,  0L);
    SET_CURLOPT(curl, CURLOPT_PROXY,            "proxy.nintendo.co.jp");
    SET_CURLOPT(curl, CURLOPT_PROXYPORT,        8080);
#endif

    /* callback */
    if (isHttps)
    {
        SET_CURLOPT(curl, CURLOPT_SSL_CTX_FUNCTION,  DefaultSslCtxFunction);
    }

    SET_CURLOPT(curl, CURLOPT_URL, url);
    res = curl_easy_perform(curl);
    if (res != CURLE_OK)
    {
        NN_LOG("curl_easy_perform() failed: %d\n", res);
    }

    curl_easy_cleanup(curl);
}

#undef SET_CURLOPT
} // ~namespace <anonymous>

TEST(AccountNw, TestCurl)
{
    ExecHttpRequest("http://kyoto.nintendo.co.jp");
    ExecHttpRequest("http://example.com");
    ExecHttpRequest("https://example.com");
}

#endif
