﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/detail/account_Settings.h>

#include <nnt/nntest.h>

namespace a = nn::account;

#define NNT_ACCOUNT_ENABLE_SETTINGS

#if defined(NNT_ACCOUNT_ENABLE_SETTINGS)

namespace testDefault
{
struct Expected
{
    bool valueAppInDevelop;
    bool valueNaRequiredForNetworkService;
    bool valueNaLoginWithSimpleMethod;
};

#if defined(NN_BUILD_CONFIG_SPEC_NX)
Expected Default = {false, true, false};
#else
Expected Default = {false, false, false};
#endif
}

TEST(AccountSettings, Default)
{
#define NNT_ACCOUNT_TEST_VALUE(key) \
    EXPECT_EQ(testDefault::Default.value ## key, a::detail::FirmwareSettings::Is ## key ())

    a::detail::FirmwareSettings::Refresh();

    NNT_ACCOUNT_TEST_VALUE(NaRequiredForNetworkService);

#undef NNT_ACCOUNT_TEST_VALUE
}

#endif // NNT_ACCOUNT_ENABLE_SETTINGS
