﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Api.h>
#include <nn/account/account_ApiForAdministrators.h>
#include <nn/account/account_ApiPrivate.h>
#include <nn/account/account_ServiceResource.h>

#include "testAccount_RamFs.h"
#include "testAccount_Mounter.h"

#include "testAccount_Util.h"
#include <nn/nn_Common.h>
#include <nn/util/util_ScopeExit.h>

namespace nnt { namespace account {

/*
    InitializeWith で使用するためのリソース
*/
typedef nn::account::ServiceResource <
    nn::account::detail::LocalStorage <nnt::account::RamFs, nnt::account::HostSaveData<>::Policy>, 0
    > DefaultTestResource;

/*
    アカウント全削除用ユーリティティ
*/
inline void CreateUsers(nn::account::Uid *pUsers, int count) NN_NOEXCEPT
{
    nn::account::InitializeForAdministrator();
    NN_UTIL_SCOPE_EXIT
    {
        nn::account::Finalize();
    };
    for (auto i = 0; i < count; ++ i)
    {
        NNT_ACCOUNT_ASSERT_RESULT_SUCCESS(nn::account::BeginUserRegistration(pUsers + i));
        NNT_ACCOUNT_ASSERT_RESULT_SUCCESS(nn::account::CompleteUserRegistration(pUsers[i]));
    }
}
template <int T>
void CreateUsers(nn::account::Uid (*pUsers)[T]) NN_NOEXCEPT
{
    CreateUsers(*pUsers, T);
}
void Cleanup() NN_NOEXCEPT;

/*
    ネットワークサービスアカウント周りのユーティリティ
*/
nn::Result RegisterNetworkServiceAccount(nn::account::NetworkServiceAccountAdministrator& admin) NN_NOEXCEPT;
nn::Result UnregisterNetworkServiceAccount(nn::account::NetworkServiceAccountAdministrator& admin) NN_NOEXCEPT;
bool IsNetworkServiceAccountRegistered(nn::account::NetworkServiceAccountAdministrator& admin) NN_NOEXCEPT;
bool IsNetworkServiceAccountNotRegistered(nn::account::NetworkServiceAccountAdministrator& admin) NN_NOEXCEPT;
bool IsNetworkServiceAccountAvailable(nn::account::NetworkServiceAccountManager& admin) NN_NOEXCEPT;
bool IsNetworkServiceAccountNotAvailable(nn::account::NetworkServiceAccountManager& admin) NN_NOEXCEPT;
bool IsNetworkServiceAccountAvailable(const nn::account::UserHandle& handle) NN_NOEXCEPT;
bool IsNetworkServiceAccountNotAvailable(const nn::account::UserHandle& handle) NN_NOEXCEPT;

}} // ~namespace nnt::account
