﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/json/account_RapidJsonStream.h>

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>
#include <nn/fs/fs_File.h>
#include <nn/os/os_ThreadApi.h>

namespace nnt { namespace account {

class MemoryInputStreamBaseForRapidJson
    : public nn::account::json::StringBufferForRapidJson
{
public:
    typedef char Ch;
private:
    typedef nn::account::json::StringBufferForRapidJson StringBuffer;
    Ch* m_Buffer;
protected:
    Ch* GetBufferAddress() NN_NOEXCEPT
    {
        return m_Buffer;
    }
    MemoryInputStreamBaseForRapidJson(Ch* buffer, size_t bufferSize) NN_NOEXCEPT
        : m_Buffer(buffer)
    {
        NN_ABORT_UNLESS(buffer != nullptr);
        SetStringBuffer(buffer, bufferSize);
    }
};

class MemoryInputStreamForRapidJson
    : public MemoryInputStreamBaseForRapidJson
{
public:
    typedef char Ch;

private:
    static const size_t StringBufferSize = 1024 * 1024;

    const char* m_Ptr;
    size_t m_Bytes;
    size_t m_Pos;

public:
    MemoryInputStreamForRapidJson() NN_NOEXCEPT
        : MemoryInputStreamBaseForRapidJson(reinterpret_cast<Ch*>(malloc(StringBufferSize)), StringBufferSize)
        , m_Ptr(nullptr)
        , m_Bytes(0u)
        , m_Pos(0u)
    {
    }
    ~MemoryInputStreamForRapidJson() NN_NOEXCEPT
    {
        free(GetBufferAddress());
    }
    void Set(const char* ptr, size_t bytes) NN_NOEXCEPT
    {
        m_Ptr = ptr;
        m_Bytes = bytes;
    }
    Ch Peek() const NN_NOEXCEPT
    {
        return m_Pos == m_Bytes? '\0': m_Ptr[m_Pos];
    }
    Ch Take() NN_NOEXCEPT
    {
        auto c = Peek();
        if (c != '\0')
        {
            ++ m_Pos;
        }
        return c;
    }
    size_t Tell() const NN_NOEXCEPT
    {
        return m_Pos;
    }
    nn::Result GetResult() const NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }
};

}} // ~namespace nnt::account
