﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testAccount_NaList.h"
#include "testAccount_Util.h"
#include <nn/account/nas/account_NasTypes.h>

namespace nnt {
namespace account {

nnt::account::Buffer GetAuthorizationViaNasProxy(const NasLoginInfo& credential, const char* url) NN_NOEXCEPT;
nnt::account::Buffer GetApplicationAuthorizationViaNasProxy(const NasLoginInfo& credential, const char* url) NN_NOEXCEPT;
nnt::account::Buffer GetAuthorizationViaNasProxyForGuest(const NasLoginInfo& credential, const char* url) NN_NOEXCEPT;
nnt::account::Buffer GetAuthorizationForError(const char* url, const char* error, const char* detail) NN_NOEXCEPT;
void RevokeAuthorization(const NasLoginInfo& credential) NN_NOEXCEPT;
}
}
