﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nnt {
namespace account {

void Initialize(bool networkRequired = false) NN_NOEXCEPT;
void Finalize(int result, bool networkRequired = false) NN_NOEXCEPT;

inline void InitializeNetworkTest() NN_NOEXCEPT
{
    Initialize(true);
}
inline void FinalizeNetworkTest(int result) NN_NOEXCEPT
{
    Finalize(result, true);
}

} // ~namespace nnt::account
}
