﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testAccount_Util.h"

#include <nn/nn_Abort.h>
#include <nn/fs/fs_FileSystem.h>
#include <nn/fs/fs_File.h>
#include <nn/util/util_ScopeExit.h>

namespace nnt {
namespace account {

class InFile
{
private:
    nn::fs::FileHandle m_File;
    Buffer m_Buffer;

public:
    explicit InFile(const char* path) NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::fs::OpenFile(&m_File, path, nn::fs::OpenMode_Read));
        NN_UTIL_SCOPE_EXIT
        {
            nn::fs::CloseFile(m_File);
        };

        int64_t size;
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::fs::GetFileSize(&size, m_File));
        m_Buffer = Buffer(static_cast<size_t>(size));

        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::fs::ReadFile(m_File, 0, m_Buffer.GetAddress(), m_Buffer.GetSize()));
    }

    const void* GetAddress() const NN_NOEXCEPT
    {
        return m_Buffer.GetAddress();
    }
    template <typename T>
    const T* Get() const NN_NOEXCEPT
    {
        return reinterpret_cast<T*>(m_Buffer.GetAddress());
    }
    size_t GetSize() const NN_NOEXCEPT
    {
        return m_Buffer.GetSize();
    }
};

}
} // ~namespace nnt::account
