﻿# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals
from HACDllDriver import factory, Button, CaptureMode, ControllerDeviceType, ControllerInterfaceType

import os
import sys
import time

os.chdir( os.path.dirname(os.path.abspath(__file__)))

"""
JoyCon, Switch Pro コントローラーの接続・切断の方法を示したサンプルです。
TargetManager にて対象開発機へ接続した状態で、InputDirector を起動してから実行する必要があります。
また(本体機能) HOMEメニューを開いた状態で実行してください。
"""

def touch_by_target_image(driver, image_path, ms_after = 1000):
    target_image    = driver.screen.load_image( image_path )
    result    = driver.screen.detect_object( target_image )
    driver.screen.release_image( target_image )
    if result is not None:
        x = result[0]
        y = result[1]
        driver.screen.touch( 0, x + 10, y + 10, ms_after = ms_after )
        return True
    else:
        print("Target image was not found")
        return False

if __name__ == "__main__":
    # sys.argv[1] = 対象のシリアルナンバー
    serial_number = None
    if len(sys.argv) != 1:
        serial_number = sys.argv[1]

    with factory(target_serial=serial_number, capture_device_id=None, capture_mode=CaptureMode.CaptureMode_720p) as driver:
        # 接続済みの仮想コントローラーを全て切断
        for i in driver.controllers.get_active_cont_id_list():
            driver.controllers.delete( i )

        # Switch Pro コントローラーを接続
        ctr_id01 = driver.controllers.add_controller(ControllerDeviceType.ControllerDeviceType_SwitchProController)

        # コントローラーサポートアプレットへ移動
        template_image_id = driver.screen.load_image("TemplateImage\Home\Controller_Icon.png")
        if template_image_id is None:
            print("Controller_Icon.png is not found")
            sys.exit(-1)

        # ホーム画面への移動を試みる
        target_pos = None
        for i in range(0,20):
            target_pos = driver.screen.wait_detect_object( image_id = template_image_id, timeout = 100 )

            if target_pos is not None:
                break

            driver.controllers[ctr_id01].push(Button.HOME)

        driver.screen.release_image(template_image_id)

        if target_pos is None:
            print("Move to home menu is failed")
            sys.exit(-1)

        # カーソルを初期位置へ移動
        driver.controllers[ctr_id01].push(Button.HOME,ms_after=1000)

        # コントローラーアイコンタップ
        driver.screen.touch( 0, target_pos[0], target_pos[1], ms_press=30, ms_after=1000)
        driver.screen.touch( 0, target_pos[0], target_pos[1], ms_press=30)
        
        # コントローラーサポートアプレットへの移動確認
        template_image_id = driver.screen.load_image("TemplateImage\ControllerApplet\Applet_Title.png")
        if driver.screen.wait_detect_object( image_id = template_image_id, timeout = 5000 ) is None:
            print("Move to controller applet is failed")
            sys.exit(-1)
            
        driver.screen.release_image(template_image_id)

        if not touch_by_target_image( driver, "TemplateImage\ControllerApplet\Change_Controller_Order_Button.png"):
            print("Move to controller applet is failed")
            sys.exit(-1)

        # コントローラー切断
        driver.controllers.delete( ctr_id01 )
        time.sleep( 1 )

        # Switch Pro コントローラーを接続
        ctr_id01 = driver.controllers.add_controller(ControllerDeviceType.ControllerDeviceType_SwitchProController, main_color=(0,0,0), sub_color=(255,0,0))

        # ２本持ちの Joy-Con を接続
        ctr_id02 = driver.controllers.add_controller(ControllerDeviceType.ControllerDeviceType_JoyConLeft, main_color=(0,0,0), sub_color=(255,0,0))
        ctr_id03 = driver.controllers.add_controller(ControllerDeviceType.ControllerDeviceType_JoyConRight, main_color=(0,0,0), sub_color=(255,0,0))

        driver.controllers[ctr_id02].press( button=Button.L, ms_before=0, ms_after=0)
        driver.controllers[ctr_id03].press( button=Button.R, ms_before=0, ms_after=0)
        time.sleep( 0.2 )
        driver.controllers[ctr_id02].release( button=Button.L, ms_before=0, ms_after=0)
        driver.controllers[ctr_id03].release( button=Button.R, ms_before=0, ms_after=0)
        time.sleep( 0.2 )

        # Joy-Con(L) を接続
        ctr_id04 = driver.controllers.add_controller(ControllerDeviceType.ControllerDeviceType_JoyConLeft, main_color=(0,0,0), sub_color=(255,0,0))
        driver.controllers[ctr_id04].push_multi( (Button.SL, Button.SR), ms_before=0, ms_after=100, ms_press=100)
        
        # Joy-Con(R) を接続
        ctr_id05 = driver.controllers.add_controller(ControllerDeviceType.ControllerDeviceType_JoyConRight, main_color=(0,0,0), sub_color=(255,0,0))
        driver.controllers[ctr_id05].push_multi( (Button.SL, Button.SR), ms_before=0, ms_after=100, ms_press=100)

        # 本体レールへ Joy-Con を接続
        ctr_id06 = driver.controllers.add_controller(ControllerDeviceType.ControllerDeviceType_JoyConLeft, ControllerInterfaceType.ControllerInterfaceType_Rail, main_color=(0,0,0), sub_color=(255,0,0))
        ctr_id07 = driver.controllers.add_controller(ControllerDeviceType.ControllerDeviceType_JoyConRight, ControllerInterfaceType.ControllerInterfaceType_Rail, main_color=(0,0,0), sub_color=(255,0,0))

        time.sleep(1)

        driver.controllers[ctr_id01].push(Button.B, ms_after=1000)
        time.sleep(3)

        # 全コントローラー切断
        for i in driver.controllers.get_active_cont_id_list():
            driver.controllers.delete( i )
        time.sleep( 1 )

        # Pro コントローラーを 8 台接続
        for i in range(8):
            driver.controllers.add_controller( ControllerDeviceType.ControllerDeviceType_SwitchProController, main_color=(0,0,0), sub_color=(255,0,0) )
            
        time.sleep( 3 )

        # 全コントローラー切断
        for i in driver.controllers.get_active_cont_id_list():
            driver.controllers.delete( i )
        time.sleep( 1 )

        # 右 Joy-Conを 8 台接続
        for i in range(8):
            driver.controllers.add_controller( ControllerDeviceType.ControllerDeviceType_JoyConRight, main_color=(0,0,0), sub_color=(255,0,0) )
            
        time.sleep( 3 )

        # 全コントローラー切断
        for i in driver.controllers.get_active_cont_id_list():
            driver.controllers.delete( i )
        time.sleep( 1 )

        # 左 Joy-Conを 8 台接続
        for i in range(8):
            driver.controllers.add_controller( ControllerDeviceType.ControllerDeviceType_JoyConLeft, main_color=(0,0,0), sub_color=(255,0,0) )
            
        time.sleep( 3 )

