﻿# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals
from HACDllDriver import factory, Button, CaptureMode

import datetime
import os
import sys
import time

os.chdir( os.path.dirname(os.path.abspath(__file__)))

"""
Ui2dDemo サンプル（Samples/Sources/Applications/Ui2dDemo）を操作するサンプルです。
Ui2dDemo アプリケーションを起動した状態で実行してください。
また事前に、TargetManager にて対象開発機へ接続した状態で、InputDirector を起動しておく必要があります。
"""

def touch_by_target_image(driver, image_path, timeout_msec=2000):
    target_image    = driver.screen.load_image( image_path )
    result          = driver.screen.wait_detect_object( target_image, timeout_msec )
    if result is not None:
        driver.screen.touch( 0, result[0] + 10, result[1] + 10)
        return True
    else:
        return False

def check_image(driver, filepath, timeout_msec = 5000):
    target_image = driver.screen.load_image( filepath )
    result = driver.screen.wait_detect_object( target_image, timeout_msec )
    driver.screen.release_image(target_image)
    if result is not None:
        print("[SUCCESS] %s was found." % (filepath))
        return True
    else:
        now = datetime.datetime.now()
        output_image = r"FailureImage_{0}_{1}.png" \
                    .format(now.strftime("%Y%m%d"), now.strftime("%H%M%S"))

        print("[FAILURE] %s was not found." % (filepath))
        print("          Save {0}.".format(output_image))

        imagehandle = driver.screen.get_image()
        driver.screen.save_image(output_image, imagehandle)
        return False

if __name__ == "__main__":
    # sys.argv[1] = 対象のシリアルナンバー
    serial_number = None
    if len(sys.argv) != 1:
        serial_number = sys.argv[1]

    with factory(target_serial=serial_number, capture_device_id=None, capture_mode=CaptureMode.CaptureMode_720p) as driver:

        debug_pad_id = driver.controllers.add_debug_pad()

        # Simple
        if not touch_by_target_image(driver, "TemplateImage/Ui2dDemo/Button_Simple.png"):
            # Simple にフォーカスが当たっていると判定に失敗するのでフォーカスをずらす
            driver.controllers[debug_pad_id].push(Button.DOWN)
            if not touch_by_target_image(driver, "TemplateImage/Ui2dDemo/Button_Simple.png"):
                print("Ui2dDemo may not be launched")
                sys.exit(-1)
        check_image(driver, "TemplateImage/Ui2dDemo/Simple.png")
        driver.controllers[debug_pad_id].push(Button.B, ms_before = 3000, ms_after=1500)

        # MultiArcResource
        if touch_by_target_image(driver, "TemplateImage/Ui2dDemo/Button_MultiArcResource.png"):
            check_image(driver, "TemplateImage/Ui2dDemo/MultiArcResource.png")
            driver.controllers[debug_pad_id].push(Button.B, ms_before = 3000, ms_after=1500)
        else:
            print("Button_MultiArcResource.png was not found")

        # TextureChange
        if touch_by_target_image(driver, "TemplateImage/Ui2dDemo/Button_TextureChange.png"):
            check_image(driver, "TemplateImage/Ui2dDemo/TextureChange.png", timeout_msec=(10 * 1000))
            driver.controllers[debug_pad_id].push(Button.B, ms_before = 3000, ms_after=1500)
        else:
            print("Button_TextureChange.png was not found")

        # UserShader
        if touch_by_target_image(driver, "TemplateImage/Ui2dDemo/Button_UserShader.png"):
            check_image(driver, "TemplateImage/Ui2dDemo/UserShader.png")
            driver.controllers[debug_pad_id].push(Button.B, ms_before = 3000, ms_after=1500)
        else:
            print("Button_UserShader.png was not found")

        # FontChange
        if touch_by_target_image(driver, "TemplateImage/Ui2dDemo/Button_FontChange.png"):
            check_image(driver, "TemplateImage/Ui2dDemo/FontChange.png")
            driver.controllers[debug_pad_id].push(Button.B, ms_before = 3000, ms_after=1500)
        else:
            print("Button_FontChange.png was not found")

        # ComplexFont
        if touch_by_target_image(driver, "TemplateImage/Ui2dDemo/Button_ComplexFont.png"):
            check_image(driver, "TemplateImage/Ui2dDemo/ComplexFont.png")
            driver.controllers[debug_pad_id].push(Button.B, ms_before = 3000, ms_after=1500)
        else:
            print("Button_ComplexFont.png was not found")

        # CannonButton
        if touch_by_target_image(driver, "TemplateImage/Ui2dDemo/Button_CannonButton.png"):
            check_image(driver, "TemplateImage/Ui2dDemo/CannonButton.png")

            for i in range(0, 3):
                touch_by_target_image(driver, "TemplateImage/Ui2dDemo/Button_Shoot.png")
                time.sleep( 0.5 )

            touch_by_target_image(driver, "TemplateImage/Ui2dDemo/Button_BlackBullet.png")
            check_image(driver, "TemplateImage/Ui2dDemo/Button_RedBullet.png")

            for i in range(0, 3):
                touch_by_target_image(driver, "TemplateImage/Ui2dDemo/Button_Shoot.png")
                time.sleep( 0.5 )
            driver.controllers[debug_pad_id].push(Button.B, ms_before = 3000, ms_after=1500)

        else:
            print("Button_CannonButton.png was not found")


        # CapturePane
        if touch_by_target_image(driver, "TemplateImage/Ui2dDemo/Button_CapturePane.png"):
            check_image(driver, "TemplateImage/Ui2dDemo/CapturePane.png")
            driver.controllers[debug_pad_id].push(Button.B, ms_before = 3000, ms_after=1500)
        else:
            print("Button_CapturePane.png was not found")

        driver.controllers[debug_pad_id].set_neutral()
