﻿# coding: utf-8
import json

def Filter(target):
	texture_info = target.Document.SelectSingleNode("//texture_info")
	if texture_info:
		obj = {
			"FileName" : target.FileName,
			"dimension" : texture_info.GetAttribute("dimension"),
			"quantize_type" : texture_info.GetAttribute("quantize_type"),
			"width" : int(texture_info.GetAttribute("width")),
			"height" : int(texture_info.GetAttribute("height")),
			"depth" : int(texture_info.GetAttribute("depth")),
			"mip_level" : int(texture_info.GetAttribute("mip_level")),
			"size" : int(texture_info.GetAttribute("size")),
			"comp_sel" : texture_info.GetAttribute("comp_sel"),
			"FullPath" : target.FullPath,
		}
		target.Result = json.dumps(obj, indent=4, separators=(',',': ')) + "\n"
	else:
		target.Result = ""

def PostFilter(targets):
	result = ""
	for target in targets:
		result += target.Result
	fp = open(ScriptArgument, "w")
	fp.write(result)
	fp.close()
