﻿# coding: utf-8
from System.IO import *

def Filter(target):
	texture_info = target.Document.SelectSingleNode("//texture_info")
	if texture_info:
		target.Result = "\"%s\",\"%s\",\"%s\",%d,%d,%d,%d,%d,\"%s\",\"%s\"\r\n" % (
				target.FileName,
				texture_info.GetAttribute("dimension"),
				texture_info.GetAttribute("quantize_type"),
				int(texture_info.GetAttribute("width")),
				int(texture_info.GetAttribute("height")),
				int(texture_info.GetAttribute("depth")),
				int(texture_info.GetAttribute("mip_level")),
				int(texture_info.GetAttribute("size")),
				texture_info.GetAttribute("comp_sel"),
				target.FullPath
			)
	else:
		target.Result = ""

def PostFilter(targets):
	result = ("\"FileName\",\"dimension\",\"quantize_type\"," +
		"\"width\",\"height\",\"depth\",\"mip_level\",\"size\",\"comp_sel\",\"FullPath\"\r\n")
	for target in targets:
		result += target.Result
	File.WriteAllText(ScriptArgument, result);
