﻿# coding: utf-8
# ユーザー名、ホスト名、日時、フルパスといった私的なデータを削除します。
def Filter(target):

	# <file_info> を削除します。
	file_info = target.Document.SelectSingleNode("/nw4f_3dif/file_info")
	if file_info:
		file_info.ParentNode.RemoveChild(file_info)

	# <process_log> の process が merge なら argument を空文字列にします。
	for process_log in target.Document.SelectNodes("//process_log"):
		if process_log.GetAttribute("process") == "merge":
			process_log.SetAttribute("argument", "")

	# テクスチャのフィルタ
	if target.Document.SelectSingleNode("/nw4f_3dif/texture"):
		FilterTexture(target)

	target.Write()

#==========================================================
# テクスチャのフィルタ
def FilterTexture(target):

	# <original_image> の original_path を空文字列にします。
	for original_image in target.Document.SelectNodes("//original_image"):
		original_image.SetAttribute("original_path", "")
