﻿# coding: utf-8
from System.IO import *

# force 以上のプリミティブ最適化が行われていないモデルの一覧を.csv ファイルに保存します。
def Filter(target):
	target.Result = ""

	# <shape_info> の optimize_primitive_mode が none か default であれば結果に追加します。
	for shape in target.Document.SelectNodes(
		"/nw4f_3dif/model/shape_array/shape"):
		shape_info = shape.SelectSingleNode("shape_info")
		mode = shape_info.GetAttribute("optimize_primitive_mode")
		if (mode == "none") or (mode == "default"):
			if target.Result == "":
				target.Result = "\"%s\",\"%s\",\"" % (target.FileName, target.FullPath)
			target.Result = target.Result + shape.GetAttribute("name") + " "

	if target.Result != "":
		target.Result += "\"\r\n"

def PostFilter(targets):
	result = "\"FileName\",\"FullPath\",\"ShapeNames\"\r\n"
	for target in targets:
		result += target.Result
	File.WriteAllText(ScriptArgument, result);
