﻿# coding: utf-8
from System.IO import *

def Filter(target):
	vertex_count = 0
	for vtx_attrib in target.Document.SelectNodes("//vtx_attrib"):
		if vtx_attrib.GetAttribute("name") == "_p0":
			vertex_count += int(vtx_attrib.GetAttribute("count"))

	polygon_count = 0
	for mesh in target.Document.SelectNodes("//mesh"):
		mesh_mode = mesh.GetAttribute("mode")
		for submesh in mesh.SelectNodes("submesh_array/submesh"):
			if mesh_mode == "triangles":
				polygon_count += int(submesh.GetAttribute("count")) / 3
			else:
				polygon_count += int(submesh.GetAttribute("count")) - 2

	target.Result = "\"%s\",%d,%d,%d,%d,%d,\"%s\"\r\n" % (
			target.FileName,
			vertex_count,
			polygon_count,
			int(GetAttribute(target, "//material_array/@length")),
			int(GetAttribute(target, "//bone_array/@length")),
			int(GetAttribute(target, "//shape_array/@length")),
			target.FullPath
		)

def GetAttribute(target, x_path):
	node = target.Document.SelectSingleNode(x_path)
	if node:
		return node.Value
	else:
		return 0

def PostFilter(targets):
	result = (
		"\"FileName\"," +
		"\"VertexCount\"," +
		"\"PolygonCount\"," +
		"\"MaterialCount\"," +
		"\"BoneCount\"," +
		"\"ShapeCount\"," +
		"\"FullPath\"\r\n"
	)
	for target in targets:
		result += target.Result
	File.WriteAllText(ScriptArgument, result);
