﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <PrimitiveHeader.glsl>

#if SHADING_MODE == SHADING_MODE_P
layout( location = 0 ) in vec3 i_Position;
#elif SHADING_MODE == SHADING_MODE_PN
layout( location = 0 ) in vec3 i_Position;
layout( location = 1 ) in vec3 i_Normal;
#elif SHADING_MODE == SHADING_MODE_PNUV
layout( location = 0 ) in vec3 i_Position;
layout( location = 1 ) in vec3 i_Normal;
layout( location = 2 ) in vec2 i_TexCoord;
#elif SHADING_MODE == SHADING_MODE_PC
layout( location = 0 ) in vec3 i_Position;
layout( location = 1 ) in vec4 i_Color;
#elif ( SHADING_MODE == SHADING_MODE_PUV || SHADING_MODE == SHADING_MODE_TEXTURE_ARRAY || SHADING_MODE == SHADING_MODE_TEXTURE_CUBEMAP )
layout( location = 0 ) in vec3 i_Position;
layout( location = 1 ) in vec2 i_TexCoord;
#else // SHADING_MODE_PUVC
layout( location = 0 ) in vec3 i_Position;
layout( location = 1 ) in vec2 i_TexCoord;
layout( location = 2 ) in vec4 i_Color;
#endif

layout( location = 0 ) out vec4 v_texCoord;
layout( location = 1 ) out vec4 v_color;
layout( location = 2 ) out vec4 v_normal;

void main()
{
    vec4 pos = vec4(i_Position, 1);
    gl_Position = pos * u_userMatrix * u_mvp;
    v_color     = u_color;

#if SHADING_MODE == SHADING_MODE_P
    v_texCoord = vec4( 0, 0, 0, 1 );
#elif SHADING_MODE == SHADING_MODE_PN
    v_texCoord	= vec4( 0, 0, 0, 1 );
	v_normal	= normalize( ( vec4( i_Normal, 0 ) * u_userMatrix * u_model ) );
#elif SHADING_MODE == SHADING_MODE_PNUV
    v_texCoord	= vec4( i_TexCoord * u_uv_size + u_uv_src, 0, 1 );
	v_normal	= normalize( ( vec4( i_Normal, 0 ) * u_userMatrix * u_model ) );
#elif SHADING_MODE == SHADING_MODE_PUV
    v_texCoord = vec4( i_TexCoord * u_uv_size + u_uv_src, 0, 1 );
#elif SHADING_MODE == SHADING_MODE_PC
    v_color *= i_Color;
#elif SHADING_MODE == SHADING_MODE_PUVC
    v_texCoord = vec4( i_TexCoord * u_uv_size + u_uv_src, 0, 1 );
    v_color *= i_Color;
#elif SHADING_MODE == SHADING_MODE_TEXTURE_ARRAY
    v_texCoord = vec4( i_TexCoord * u_uv_size + u_uv_src, 0, 1 );
#elif SHADING_MODE == SHADING_MODE_TEXTURE_CUBEMAP
    v_texCoord = vec4( i_TexCoord * u_uv_size + u_uv_src, 0, 1 );
#endif
}