﻿function BuildSampleAll()
{
    Param
    (
        $BuildVersionList,
        $SampleNameList,
        $BuildPlatformList,
        $MSBuildPath,
        $SlnSuffix
    )

    foreach($BuildVersionLocal in $BuildVersionList)
    {
        foreach($PlatformLocal in $BuildPlatformList)
        {
            foreach($SampleNameLocal in $SampleNameList)
            {
                $SolutionName = $SampleNameLocal + $SlnSuffix
                $SolutionPath = $SdkRoot + "\Samples\Sources\Applications\" + $SampleNameLocal + "\" +  $SolutionName
                $ConfigStr = "/p:Configuration=" + $BuildVersionLocal
                $PlatformStr = "/p:Platform=" + $PlatformLocal
                
                Write-Host $MSBuildPath $SolutionPath $ConfigStr $PlatformStr
                & $MSBuildPath $SolutionPath $ConfigStr $PlatformStr
            }
        }
    }
}

function BuildVS2013Generic()
{
    Param
    (
        $BuildVersionList,
        $SampleNameList,
        $BuildPlatformList
    )

    $SlnSuffix = "-spec.Generic.autogen.vs2013.sln"
    $MSBuildPath = $MSBuildRoot + "\12.0\Bin\MsBuild.exe"

    BuildSampleAll $BuildVersionList $SampleNameList $BuildPlatformList $MSBuildPath $SlnSuffix
}

function BuildVS2015Generic()
{
    Param
    (
        $BuildVersionList,
        $SampleNameList,
        $BuildPlatformList
    )

    $SlnSuffix = "-spec.Generic.autogen.vs2015.sln"
    $MSBuildPath = $MSBuildRoot + "\14.0\Bin\MsBuild.exe"

    BuildSampleAll $BuildVersionList $SampleNameList $BuildPlatformList $MSBuildPath $SlnSuffix
}

function BuildVS2017Generic()
{
    Param
    (
        $BuildVersionList,
        $SampleNameList,
        $BuildPlatformList
    )

    $SlnSuffix = "-spec.Generic.autogen.vs2017.sln"
    $MSBuildPath = $VisualStudioRoot + "\2017\Professional\MSBuild\15.0\Bin\MsBuild.exe"

    BuildSampleAll $BuildVersionList $SampleNameList $BuildPlatformList $MSBuildPath $SlnSuffix
}

function BuildVS2013NX()
{
    Param
    (
        $BuildVersionList,
        $SampleNameList,
        $BuildPlatformList
    )

    $SlnSuffix = "-spec.NX.autogen.vs2013.sln"
    $MSBuildPath = $MSBuildRoot + "\12.0\Bin\MsBuild.exe"

    BuildSampleAll $BuildVersionList $SampleNameList $BuildPlatformList $MSBuildPath $SlnSuffix
}

function BuildVS2015NX()
{
    Param
    (
        $BuildVersionList,
        $SampleNameList,
        $BuildPlatformList
    )

    $SlnSuffix = "-spec.NX.autogen.vs2015.sln"
    $MSBuildPath = $MSBuildRoot + "\14.0\Bin\MsBuild.exe"

    BuildSampleAll $BuildVersionList $SampleNameList $BuildPlatformList $MSBuildPath $SlnSuffix
}

function BuildVS2017NX()
{
    Param
    (
        $BuildVersionList,
        $SampleNameList,
        $BuildPlatformList
    )

    $SlnSuffix = "-spec.NX.autogen.vs2017.sln"
    $MSBuildPath = $VisualStudioRoot + "\2017\Professional\MSBuild\15.0\Bin\MsBuild.exe"

    BuildSampleAll $BuildVersionList $SampleNameList $BuildPlatformList $MSBuildPath $SlnSuffix
}
