﻿# ----------------------------------------------
# パスなどの設定
# ----------------------------------------------

$AutoPilotRoot = Split-Path -Parent $MyInvocation.MyCommand.Path
$ScriptDir = $AutoPilotRoot + "\script"
$OperationDir = $AutoPilotRoot + "\operation"
$SdkRoot = $AutoPilotRoot + "\..\..\..\..\.."

$OutputDir = $SdkRoot + "\Samples\Resources\Atk\AutoPilot"

$LogDir = $OutputDir + "\Log"
$UserSettingFile = $OutputDir + "\UserSetting.ps1"

$HidShell = $SdkRoot + "\Tools\CommandLineTools\Hid\HidShell.exe"
$RunOnTarget = $SdkRoot + "\Tools\CommandLineTools\RunOnTarget.exe"
$ControlTarget = $SdkRoot + "\Tools\CommandLineTools\ControlTarget.exe"
$InputDirector = $SdkRoot + "\Tools\Hid\InputDirector\InputDirector.exe"

$RunSampleScript = $ScriptDir + "\Run-Sample.ps1"
$PlaybackScript = $ScriptDir + "\Playback-Log.ps1"
$InputDirectorStartScript = $ScriptDir + "\Start-InputDirector.ps1"
$InputDirectorStopScript = $ScriptDir + "\Stop-InputDirector.ps1"
$BuildSampleAllScript = $ScriptDir + "\Build-SampleAll.ps1"
$RunSampleAllImplScript = $ScriptDir + "\Run-SampleAll-Impl.ps1"

# ----------------------------------------------
# 自動実行の組み合わせ
# ----------------------------------------------

$IsPackage = $true

$SampleNameList = @(
    "AtkAddonSoundArchive",
    "AtkEffect",
    "AtkFilter",
    "AtkGroup",
    "AtkMixMode",
    "AtkProfile",
    "AtkSimple",
    "AtkSound3D",
    "AtkSoundActor",
    "AtkStreamSound",
    "AtkSubMix"
)

$BuildVersionList = @(
    "Release",
    "Develop",
    "Debug"
)

$PlatformList = @(
    "NX-NXFP2-a64",
    "NX-NXFP2-a32"
#    "x64-v140",
#    "Win32-v140"
)

$BuildGenericPlatformList = @(
    "Win32",
    "x64"
)

$BuildNXPlatformList = @(
    "NX64",
    "NX32"
)

# ----------------------------------------------
# 対象ターゲット（書き換えてください）
# ----------------------------------------------
$TargetList = @(
    "XAL02100038938",
    "XAL03100057189"
)

# ----------------------------------------------
# 環境依存のパス設定（書き換えてください）
# ----------------------------------------------
$MSBuildRoot = "C:\Program Files (x86)\MSBuild"
$VisualStudioRoot = "C:\Program Files (x86)\Microsoft Visual Studio"

# ユーザ設定を確認しあれば読み込む
$IsUserSettingFileExist = Test-Path $UserSettingFile
if ($IsUserSettingFileExist -eq $True)
{
    . $UserSettingFile
}
