﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nns/nac/nac_Mouse.h>

#if defined( NN_BUILD_TARGET_PLATFORM_OS_WIN)
#define WIN32_LEAN_AND_MEAN
#define NOMINMAX
#include <nn/nn_Windows.h>
#endif

namespace nns {
namespace nac {

//---------------------------------------------------------------------------
//! @brief        コンストラクタです。
//---------------------------------------------------------------------------
Mouse::Mouse()
#if defined( NN_BUILD_TARGET_PLATFORM_OS_WIN)
    : m_WindowHandle(NULL),
      m_Press(),
      m_PressPrev(),
      m_Trigger(),
      m_Release(),
      m_IsUseKeyboardForcus( false ),
      m_MouseTriggeredNow(0)
#endif
{
#if defined( NN_BUILD_TARGET_PLATFORM_OS_WIN)
    // Win 版のみ実装
#endif
}

//---------------------------------------------------------------------------
//! @brief        デストラクタです。
//---------------------------------------------------------------------------
Mouse::~Mouse()
{
#if defined( NN_BUILD_TARGET_PLATFORM_OS_WIN)
    // Win 版のみ実装
#endif
}

//---------------------------------------------------------------------------
//! @brief        初期化
//---------------------------------------------------------------------------
bool Mouse::Initialize( void* hWnd )
{
#if defined( NN_BUILD_TARGET_PLATFORM_OS_WIN)
    // Win 版のみ実装
    nn::hid::InitializeMouse();
    m_WindowHandle = hWnd;

#endif
    return true;
}

//---------------------------------------------------------------------------
//! @brief        解放処理
//---------------------------------------------------------------------------
void Mouse::Finalize()
{
#if defined( NN_BUILD_TARGET_PLATFORM_OS_WIN)
    // Win 版のみ実装
#endif
}

//---------------------------------------------------------------------------
//! @brief        毎フレームごとのアップデート
//---------------------------------------------------------------------------
void Mouse::Update( bool isSetFocus )
{
#if defined( NN_BUILD_TARGET_PLATFORM_OS_WIN)
    // Win 版のみ実装

    m_PrevCursorOnClientArea = m_CursorOnClientArea;
    m_PressPrev             = m_Press;
    memcpy( &m_MousePrev, &m_Mouse, sizeof(nn::hid::MouseState) );

    m_CursorOnClientArea     = false;
    m_Press.Clear();

    // ホイール回転差分を探す
    nn::hid::MouseState states[nn::hid::MouseStateCountMax];
    int count = nn::hid::GetMouseStates(states, nn::hid::MouseStateCountMax);

    bool isFind = false;
    for (int i = 0; i < count; ++i)
    {
        if ( states[i].wheelDelta )
        {
            if ( states[i].samplingNumber != m_WheelSamplingNumber )
            {
                m_WheelSamplingNumber = states[i].samplingNumber;
                m_WheelDelta          = states[i].wheelDelta;
                isFind                = true;
                break;
            }
        }
    }
    // ホイール回転差分がない場合はクリアする
    if ( !isFind )
    {
        m_WheelDelta          = 0;
    }

    // 最初のマウスサンプリングデータを取得する
    if ( m_MousePrev.samplingNumber != states[0].samplingNumber )
    {
        memcpy( &m_Mouse, &states[0], sizeof(nn::hid::MouseState) );

        if ( m_IsUseKeyboardForcus )
        {
            POINT point;
            GetCursorPos(&point);
            m_Mouse.x = point.x;
            m_Mouse.y = point.y;
        }
        // マウス入力状態を取得する
        m_Press.SetBit( IDX_LBUTTON,  m_Mouse.buttons.Test< nn::hid::MouseButton::Left>() );
        m_Press.SetBit( IDX_RBUTTON,  m_Mouse.buttons.Test< nn::hid::MouseButton::Right>() );
        m_Press.SetBit( IDX_MBUTTON,  m_Mouse.buttons.Test< nn::hid::MouseButton::Middle>() );
    }
    m_Trigger.storage = (m_Press.storage ^ m_PressPrev.storage) & m_Press.storage;
    m_Release.storage = (m_Press.storage ^ m_PressPrev.storage) & m_PressPrev.storage;

    // マウスがアクティブなウィンドウ上にあるかを調査する
    if ( m_IsUseKeyboardForcus )
    {
        m_CursorOnClientArea = isSetFocus;
        return;
    }

    POINT point;
    if ( GetCursorPos(&point) )
    {
        HWND foregroundWindow = GetForegroundWindow();

        if ( m_WindowHandle == foregroundWindow)
        {
            POINT clientPoint = point;
            if ( ScreenToClient(foregroundWindow, &clientPoint ) )
            {
                RECT rect;

                // カーソルがクライアント領域の上にあるか否かを取得
                if ( GetClientRect(foregroundWindow, &rect) )
                {
                    if ( 0 <= clientPoint.x && clientPoint.x <= rect.right &&
                         0 <= clientPoint.y && clientPoint.y <= rect.bottom )
                    {
                        m_CursorOnClientArea = true;
                    }
                }
            }
        }
    }

    // マウスがアクティブウィンドウに入った直後の処理
    if ( m_CursorOnClientArea )
    {
         uint32_t mask = 0xffffffff;
        if ( ( !m_MouseTriggeredNow ) &&  ( ( IsHold(mask) ) || m_WheelDelta ) )
        {
            memcpy( &m_MousePrev, &m_Mouse, sizeof(nn::hid::MouseState) );
            m_MouseTriggeredNow = true;
        }
    }
    else
    {
        m_MouseTriggeredNow = false;
    }
#endif
}

}
}
