﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_TouchScreen.h>
#include <nns/hid/hid_TouchScreenAsset.h>

namespace nns { namespace hid {

TouchScreenAsset::TouchScreenAsset(ControllerManager* pManager) NN_NOEXCEPT
    : DeviceAsset(pManager)
    , m_SamplingNumber(-1)
{
    NN_ASSERT_NOT_NULL(pManager);
}

TouchScreenAsset::~TouchScreenAsset() NN_NOEXCEPT {}

void TouchScreenAsset::Initialize() NN_NOEXCEPT
{
    // TouchScreen を初期化します。
    nn::hid::InitializeTouchScreen();
}

void TouchScreenAsset::Update() NN_NOEXCEPT
{
    // 前回の TouchScreen の入力状態を破棄します。
    m_States.clear();

    // TouchScreen の入力状態を取得します。
    const int count = nn::hid::GetTouchScreenStates(
        m_TemporaryStates, nn::hid::TouchScreenStateCountMax);

    // 新たに観測された入力状態を記録します。
    for (int i = 0; i < count; ++i)
    {
        const TouchScreenState& state = m_TemporaryStates[i];

        if (state.samplingNumber <= m_SamplingNumber)
        {
            break;
        }

        m_States.push_back(state);
    }

    // 最新のサンプリング番号を更新します。
    if (count > 0)
    {
        m_SamplingNumber = m_TemporaryStates[0].samplingNumber;
    }
}

}} // namespace nns::hid
