﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Macro.h>
#include <nn/hid/hid_Keyboard.h>
#include <nns/hid/hid_KeyboardAsset.h>

namespace nns { namespace hid {

KeyboardAsset::KeyboardAsset(ControllerManager* pManager) NN_NOEXCEPT
    : DeviceAsset(pManager)
{
    NN_ASSERT_NOT_NULL(pManager);
}

KeyboardAsset::~KeyboardAsset() NN_NOEXCEPT {}

void KeyboardAsset::Initialize() NN_NOEXCEPT
{
    // Keyboard を初期化します。
    nn::hid::InitializeKeyboard();
}

void KeyboardAsset::Update() NN_NOEXCEPT
{
    // Keyboard の入力状態を取得します。
    nn::hid::GetKeyboardState(&m_State);
}

}} // namespace nns::hid
