﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/nn_Assert.h>
#include "gfxLogLogOut.h"

namespace nns {
namespace gfxLog {
/**
* @brief テキスト色を設定します。
*
* @param[in] Color    設定する色
* @details   次に描画するときの使用するテキスト色を設定します。
*/
void SetTextColor(const nn::util::Color4u8& Color) NN_NOEXCEPT
{
    LogOut::SetTextColor(Color);
}

/**
* @brief 背景色を設定します。
*
* @param[in] Color    設定する色
* @details   次に描画するときの使用する背景色を設定します。
*/
void SetBackgroudColor(const nn::util::Color4u8& Color) NN_NOEXCEPT
{
    LogOut::SetBackgroudColor(Color);
}

/**
* @brief 描画領域を設定します。
*
* @param[in]    Left    左のX座標
* @param[in]    Top     上のY座標
* @param[in]    Width   幅
* @param[in]    Height  高さ
* @details   次に描画するときの使用する矩形を設定します。
*/
void SetDrawRect(
    const float Left,
    const float Top,
    const float Width,
    const float Height
) NN_NOEXCEPT
{
    LogOut::SetDrawRect(Left, Top, Width, Height);
}

/**
* @brief ログ描画用スレッドのコアを設定します。
*
* @param[in] idealCore     優先して動作するコア番号
* @details ログ描画用スレッドのコア割り当てを設定します。
*/
void SetThreadCoreNumber(int idealCore) NN_NOEXCEPT
{
    LogOut::SetThreadCoreNumber(idealCore);
}

/**
* @brief 描画コマンドを発行します。
*
* @details 描画コマンドを発行します。SetConfiguration が呼ばれた場合のみ処理を行います。
*/
void WriteCommand() NN_NOEXCEPT
{
    LogOut::WriteCommand();
}

/**
* @brief デバイス、コマンドバッファ、デバッグフォントライターを設定します。
*
* @param[in]    pDevice               デバイス
* @param[in]    pCommandBuffer        コマンドバッファ
* @param[in]    pDebugFontWriter      デバッグフォントライター
* @details アプリケーションで描画したい場合にデバイス、コマンドバッファ、
*          デバッグフォントライターをを設定します。
*/
void SetConfiguration(
    nn::gfx::Device* pDevice,
    nn::gfx::CommandBuffer* pCommandBuffer,
    nn::gfx::util::DebugFontTextWriter* pDebugFontWriter) NN_NOEXCEPT
{
    NN_ASSERT_NOT_NULL(pDevice);
    NN_ASSERT_NOT_NULL(pCommandBuffer);
    NN_ASSERT_NOT_NULL(pDebugFontWriter);

    LogOut::SetConfiguration(pDevice, pCommandBuffer, pDebugFontWriter);
}
} // namespace gfxLog
} // namespace nns
