﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <PrimitiveHeader.glsl>

#if SHADING_MODE == SHADING_MODE_SOLID_COLOR
layout( location = 0 ) in vec3 i_Position;
#elif SHADING_MODE == SHADING_MODE_VERTEX_COLOR
layout( location = 0 ) in vec3 i_Position;
layout( location = 1 ) in vec4 i_Color;
#else // Texture
layout( location = 0 ) in vec3 i_Position;
layout( location = 1 ) in vec4 i_Color;
layout( location = 2 ) in vec2 i_TexCoord;
#endif

layout( location = 0 ) out vec4 v_texCoord;
layout( location = 1 ) out vec4 v_color;

void main()
{
    vec4 pos = vec4(i_Position, 1);
    gl_Position = pos * u_userMatrix * u_mvp;

#if SHADING_MODE == SHADING_MODE_SOLID_COLOR
    v_texCoord = vec4( 0, 0, 0, 1 );
    v_color    = u_color;
#elif SHADING_MODE == SHADING_MODE_VERTEX_COLOR
    v_texCoord = vec4( 0, 0, 0, 1 );
    v_color    = u_color * i_Color;
#else
    v_texCoord = vec4( i_TexCoord * u_uv_size + u_uv_src, 0, 1 );
    v_color    = u_color * i_Color;
#endif
}
