﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;

namespace nns.gfx0
{
    [CppRefPath(@"<nns/gfx0/gfx0_IGfx0Driver.sfdl.h>")]
    public interface IGfx0Driver : IServiceObject
    {
        [MethodId(0)]
        Result WaitServerReady();
        [MethodId(1)]
        Result AddValue(Out<int32_t> pOut, int32_t x, int32_t y);
        [MethodId(2)]
        Result AttachTransferMemoryImpl(NativeHandle handle, uint64_t size);
        [MethodId(3)]
        Result AttachDeviceMemory(NativeHandle processHandle, uint64_t address, uint64_t size);
        [MethodId(4)]
        Result QuerySharedMemoryImpl(Out<NativeHandle> handle, Out<uint64_t> size);
        [MethodId(5)]
        Result QuerySystemEventImpl(Out<NativeHandle> handle);
        [MethodId(6)]
        void AdvanceDemo();
    }
}
