﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>

#include <nn/sf/sf_HipcClientProxyByName.h> // for nn::sf::CreateHipcProxyByName
#include <nn/sf/sf_ExpHeapAllocator.h>      // for nn::sf::ExpHeapStaticAllocator

#include <nns/gfx0/gfx0_IGfx0Driver.sfdl.h> // for IGfx0Driver
#include <nns/gfx0/gfx0_Driver.h>           // for IGfx0Driver
#include <nns/gfx0/gfx0_ServiceName.h>      // for IGfx0Driver

#include "gfx0_DriverImpl.h"

namespace nns { namespace gfx0 {

namespace {

//-----------------------------------------------------------------------------
// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct  Gfx0DriverByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, Gfx0DriverByHipcTag> Gfx0Allocator;

//-----------------------------------------------------------------------------
// Gfx0Allocator を静的コンストラクタで初期化するためのヘルパー
class Gfx0AllocatorInitializer
{
public:

    Gfx0AllocatorInitializer() NN_NOEXCEPT
    {
        Gfx0Allocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_Gfx0AllocatorInitializer;

}

//-----------------------------------------------------------------------------
//  グラフィックドライバのサービスを HIPC として初期化して使用可能にします。
//
nn::sf::SharedPointer<IGfx0Driver> CreateGfx0DriverByHipc() NN_NOEXCEPT
{
    // Gfx0DriverServiceName のサービス名で示される HIPC サービスオブジェクトを
    // IGfx0Driver としてプロキシクライアントを作成して返します。
    // アロケーションポリシーとして Gfx0Allocator::Policy を渡している。
    nn::sf::SharedPointer<IGfx0Driver> ret;
    auto result = nn::sf::CreateHipcProxyByName<IGfx0Driver, Gfx0Allocator::Policy>(&ret, Gfx0DriverServiceName);
    NN_ABORT_UNLESS(result.IsSuccess());
    return ret;
}

//-----------------------------------------------------------------------------

}}  // namespace nns::gfx0

