﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/os.h>

#include "display0_DriverSample.h"

namespace nns { namespace display0 {

namespace {

NN_ALIGNAS(4096) uint8_t    g_ThreadStack[4096];

}   // namespace

//-----------------------------------------------------------------------------

void Display0DriverSample::ThreadFunc(void* arg) NN_NOEXCEPT
{
    auto* p = reinterpret_cast<Display0DriverSample*>(arg);

    while (!p->GetFinalizeRequest())
    {
        nn::os::WaitSystemEvent( &p->m_SystemEvent );
        NN_SDK_LOG("Display0: Synchronized.\n");
    }
}

//-----------------------------------------------------------------------------

void Display0DriverSample::Initialize(nn::os::NativeHandle handle, bool isManaged)
{
    NN_SDK_ASSERT( m_SystemEventAvailable == false );

    // Prepare SystemEvent
    nn::os::AttachReadableHandleToSystemEvent(&m_SystemEvent, handle, isManaged, nn::os::EventClearMode_AutoClear);
    m_SystemEventAvailable = true;
    m_FinalizeRequest      = false;

    // Create service thread
    auto result = nn::os::CreateThread(&m_Thread, &Display0DriverSample::ThreadFunc, this, reinterpret_cast<void*>(g_ThreadStack), sizeof(g_ThreadStack), nn::os::HighestThreadPriority);
    NN_SDK_ASSERT( result.IsSuccess() );
    NN_UNUSED( result );

    nn::os::StartThread( &m_Thread );
}

//-----------------------------------------------------------------------------

void Display0DriverSample::Finalize() NN_NOEXCEPT
{
    m_FinalizeRequest = true;

    nn::os::WaitThread( &m_Thread );
    nn::os::DestroyThread( &m_Thread );

    if (m_SystemEventAvailable)
    {
        nn::os::DestroySystemEvent( &m_SystemEvent );
    }
}

//-----------------------------------------------------------------------------

}}  // namespace nns::display0

