﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

#include <nns/display0/display0_Driver.h>
#include "display0_DriverImpl.h"

namespace nns { namespace display0 {

namespace {

//-----------------------------------------------------------------------------
// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct  Display0DriverByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, Display0DriverByHipcTag> Display0Allocator;

//-----------------------------------------------------------------------------
// Display0Allocator を静的コンストラクタで初期化するためのヘルパー
class Display0AllocatorInitializer
{
public:

    Display0AllocatorInitializer() NN_NOEXCEPT
    {
        Display0Allocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_Display0AllocatorInitializer;

}   // namespace

//-----------------------------------------------------------------------------
//  グラフィックドライバのサービスを DFC として初期化して使用可能にしま>す。
//
nn::sf::SharedPointer<IDisplay0Driver> CreateDisplay0DriverByDfc() NN_NOEXCEPT
{
    typedef nn::sf::ObjectFactory<Display0Allocator::Policy>    Factory;

    return Factory::CreateSharedEmplaced<IDisplay0Driver, Display0DriverImpl>();
}

//-----------------------------------------------------------------------------

}}  // namespace nns::display0

