﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx/gfx_State.h>
#include <nn/gfx/gfx_ResShader.h>
#include <nn/gfx/gfx_Shader.h>
#include <nn/gfx/gfx_Texture.h>
#include <nn/gfx/gfx_DescriptorSlot.h>
#include <nn/gfx/gfx_DescriptorPool.h>
#include <nn/gfx/gfx_Sampler.h>
#include <nn/gfx/gfx_Buffer.h>
#include <nn/gfx/gfx_MemoryPool.h>
#include <nn/gfx/gfx_CommandBuffer.h>
#include <nn/gfx/gfx_GpuAddress.h>

#define NNS_DBGUI_MEMORYPOOL_CPU_CACHED

struct ImDrawData;
struct ImVec4;
typedef void* ImTextureID;

namespace nns { namespace dbgui {

class InterfaceInfo;
class Allocator;

class Renderer
{
    NN_DISALLOW_COPY(Renderer);

private:

    static const nn::gfx::ImageFormat   FontTextureFormat = nn::gfx::ImageFormat_R8_Unorm;
    static const int                    VertexBufferSize = 1 * 1024 * 1024;
    static const int                    IndexBufferSize = 512 * 1024;
    static const int                    ConstantBufferSize = sizeof(float) * 4;

    static const int                    ConstantBufferShaderBindingSlot = 0;
    static const int                    TextureShaderBindingSlot = 0;

    nn::gfx::DescriptorPool*            m_pSamplerDescriptorPool;
    int                                 m_SamplerDescriptorPoolIndex;
    nn::gfx::DescriptorPool*            m_pTextureViewDescriptorPool;
    int                                 m_TextureViewDescriptorPoolIndex;
    nn::gfx::DescriptorPool*            m_pConstantBufferDescriptorPool;
    int                                 m_ConstantBufferDescriptorPoolIndex;

    int                                 m_ImguiDisplayWidth;
    int                                 m_ImguiDisplayHeight;

    UpdateScissorCallback               m_pUpdateScissorCallback;
    void*                               m_pUpdateScissorCallbackUserData;

    // ビューポートのY軸の方面　（ビューポート射影）
    ViewportYAxisDirection              m_ViewportYAxisDirection;

    int                                 m_BufferCount;
    int                                 m_BufferIndex;

    nn::gfx::MemoryPool                 m_ShaderMemoryPool;
    nn::gfx::ResShaderFile*             m_pResShaderFile;
    nn::gfx::ShaderCodeType             m_ResShaderCodeType;

    nn::gfx::VertexState                m_VertexState;
    nn::gfx::RasterizerState            m_RasterizerState;
    nn::gfx::DepthStencilState          m_DepthStencilState;
    nn::gfx::BlendState                 m_BlendState;

    nn::gfx::Texture                    m_FontTexture;
    nn::gfx::TextureView                m_FontTextureView;
    nn::gfx::Sampler                    m_FontTextureSampler;

    nn::gfx::Buffer                     m_ConstantBuffer;
    nn::gfx::Buffer*                    m_pIndexBufferArray;
    nn::gfx::Buffer*                    m_pVertexBufferArray;

    nn::gfx::DescriptorSlot             m_FontTextureDescriptorSlot;
    nn::gfx::DescriptorSlot             m_FontTextureSamplerDescriptorSlot;
    nn::gfx::DescriptorSlot             m_ConstantBufferDescriptorSlot;

    Allocator*                          m_pAllocator;

public:

            Renderer();
            ~Renderer();

    void    Initialize(const InterfaceInfo& info, Allocator* pAllocator);
    void    Finalize();

    void    InitializeGfxObjects(nn::gfx::Device* pDevice);
    void    FinalizeGfxObjects(nn::gfx::Device* pDevice);

    int     GetImguiDisplayWidth() const;
    int     GetImguiDisplayHeight() const;

    void    RenderDrawLists(nn::gfx::CommandBuffer* pCommandBuffer, ImDrawData* pDrawData);

public:
    static size_t           ComputeGpuPoolMemoryRequired(nn::gfx::Device* pDevice, int bufferCount);


    void                    InitializeShader(nn::gfx::Device* pDevice);
    void                    FinalizeShader(nn::gfx::Device* pDevice);

    void                    InitializeVertexState(nn::gfx::Device* pDevice);
    void                    FinalizeVertexState(nn::gfx::Device* pDevice);

    void                    InitializeRasterizerState(nn::gfx::Device* pDevice);
    void                    FinalizeRasterizerState(nn::gfx::Device* pDevice);

    void                    InitializeBlendState(nn::gfx::Device* pDevice);
    void                    FinalizeBlendState(nn::gfx::Device* pDevice);

    void                    InitializeDepthStencilState(nn::gfx::Device* pDevice);
    void                    FinalizeDepthStencilState(nn::gfx::Device* pDevice);

    void                    InitializeFontTexture(nn::gfx::Device* pDevice);
    void                    FinalizeFontTexture(nn::gfx::Device* pDevice);

    void                    InitializeBuffers(nn::gfx::Device* pDevice);
    void                    FinalizeBuffers(nn::gfx::Device* pDevice);

    void                    SetDescriptorlots();
    void                    UpdateConstantBuffer();

    bool                    TestRectEquals(const ImVec4* pRect0, const ImVec4* pRect1);
    void                    SetScissor(nn::gfx::CommandBuffer* pCommandBuffer, const ImVec4* pScissor);
    void                    SetTexture(nn::gfx::CommandBuffer* pCommandBuffer, ImTextureID textureId);
};

inline int Renderer::GetImguiDisplayWidth() const
{
    return m_ImguiDisplayWidth;
}

inline int Renderer::GetImguiDisplayHeight() const
{
    return m_ImguiDisplayHeight;
}

} } // namespace nns { namespace dbgui {
