﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nns { namespace afx {

static const float SrcTab12khz[128 * 4] =
{
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0C7Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x66AFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0D01u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFE0u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0BF8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x66A9u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0D8Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFDEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0B78u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x669Eu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0E18u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFDAu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0AFBu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x668Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0EA7u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFD6u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0A80u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6676u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0F39u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFD2u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0A08u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x665Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0FCEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFCEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0993u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6639u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1067u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFCAu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0922u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6612u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1102u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFC6u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x08B3u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x65E5u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x11A0u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFC1u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0848u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x65B3u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1241u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFBDu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x07DFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x657Cu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x12E5u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFB8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0778u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x653Fu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x138Cu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFB4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0715u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x64FCu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1436u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFAFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x06B4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x64B4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x14E3u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFA9u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0656u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6468u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1592u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFA4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x05FBu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6415u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1645u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF9Eu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x05A2u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x63BDu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x16FAu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF99u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x054Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6360u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x17B2u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF93u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x04FAu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x62FEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x186Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF8Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x04A9u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6297u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x192Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF87u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x045Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x622Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x19EBu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF81u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0410u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x61BAu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1AAEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF7Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x03C7u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6143u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1B73u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF74u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0381u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x60C8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1C3Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF6Eu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x033Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6048u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1D06u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF67u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x02FCu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5FC4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1DD3u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF61u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x02BDu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5F3Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1EA2u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF5Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0281u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5EADu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1F74u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF52u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0247u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5E1Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2048u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF4Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x020Eu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5D84u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x211Eu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF45u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x01D8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5CE9u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x21F7u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF3Eu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x01A4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5C4Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x22D2u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF36u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0173u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5BA6u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x23AFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF2Fu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0144u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5AFFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x248Eu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF29u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0117u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5A53u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x256Fu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF22u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x00ECu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x59A4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2651u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF1Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x00C2u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x58F1u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2736u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF13u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x009Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x583Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x281Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF0Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0075u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x577Fu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2905u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF06u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0051u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x56C0u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x29EFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEFEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x002Fu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x55FFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2ADAu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEF7u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x000Fu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x553Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2BC6u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEF1u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFF0u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5472u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2CB4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEEBu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFD4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x53A7u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2DA4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEE5u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFB9u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x52D8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2E94u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEDEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF9Fu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5207u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2F86u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFED8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF87u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5132u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3079u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFED2u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF71u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x505Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x316Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFECEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF5Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4F82u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3262u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEC9u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF49u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4EA6u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3357u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEC4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF37u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4DC7u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x344Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEBFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF26u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4CE6u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3543u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEBBu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF16u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4C03u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x363Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEB8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF08u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4B1Eu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3732u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEB4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEFBu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4A36u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3829u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEB1u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEEFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x494Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3921u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEAFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEE4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4863u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3A19u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEADu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEDAu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4777u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3B11u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEABu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFED2u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4689u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3C09u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEABu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFECAu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4599u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3D01u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEABu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEC3u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x44A9u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3DF8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEACu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEBDu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x43B7u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3EEFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEACu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEB8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x42C4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3FE5u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEAEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEB4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x41D0u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x40DBu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEB0u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEB0u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x40DBu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x41D0u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEB4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEAEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3FE5u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x42C4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEB8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEACu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3EEFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x43B7u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEBDu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEACu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3DF8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x44A9u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEC3u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEABu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3D01u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4599u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFECAu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEABu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3C09u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4689u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFED2u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEABu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3B11u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4777u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEDAu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEADu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3A19u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4863u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEE4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEAFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3921u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x494Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEEFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEB1u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3829u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4A36u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEFBu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEB4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3732u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4B1Eu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF08u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEB8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x363Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4C03u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF16u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEBBu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3543u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4CE6u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF26u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEBFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x344Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4DC7u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF37u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEC4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3357u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4EA6u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF49u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEC9u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3262u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x4F82u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF5Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFECEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x316Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x505Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF71u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFED2u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x3079u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5132u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF87u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFED8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2F86u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5207u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF9Fu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEDEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2E94u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x52D8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFB9u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEE5u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2DA4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x53A7u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFD4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEEBu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2CB4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5472u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFF0u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEF1u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2BC6u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x553Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x000Fu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEF7u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2ADAu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x55FFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x002Fu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFEFEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x29EFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x56C0u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0051u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF06u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2905u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x577Fu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0075u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF0Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x281Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x583Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x009Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF13u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2736u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x58F1u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x00C2u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF1Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2651u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x59A4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x00ECu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF22u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x256Fu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5A53u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0117u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF29u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x248Eu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5AFFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0144u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF2Fu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x23AFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5BA6u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0173u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF36u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x22D2u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5C4Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x01A4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF3Eu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x21F7u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5CE9u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x01D8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF45u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x211Eu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5D84u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x020Eu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF4Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x2048u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5E1Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0247u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF52u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1F74u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5EADu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0281u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF5Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1EA2u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5F3Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x02BDu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF61u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1DD3u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x5FC4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x02FCu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF67u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1D06u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6048u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x033Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF6Eu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1C3Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x60C8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0381u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF74u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1B73u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6143u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x03C7u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF7Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1AAEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x61BAu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0410u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF81u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x19EBu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x622Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x045Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF87u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x192Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6297u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x04A9u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF8Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x186Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x62FEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x04FAu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF93u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x17B2u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6360u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x054Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF99u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x16FAu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x63BDu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x05A2u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFF9Eu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1645u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6415u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x05FBu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFA4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1592u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6468u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0656u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFA9u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x14E3u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x64B4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x06B4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFAFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1436u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x64FCu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0715u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFB4u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x138Cu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x653Fu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0778u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFB8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x12E5u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x657Cu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x07DFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFBDu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1241u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x65B3u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0848u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFC1u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x11A0u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x65E5u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x08B3u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFC6u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1102u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6612u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0922u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFCAu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x1067u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6639u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0993u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFCEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0FCEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x665Au),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0A08u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFD2u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0F39u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x6676u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0A80u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFD6u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0EA7u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x668Du),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0AFBu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFDAu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0E18u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x669Eu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0B78u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFDEu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0D8Bu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x66A9u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0BF8u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0xFFE0u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0D01u),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x66AFu),
    (1.0f / 32768.0f) * static_cast<int16_t>(0x0C7Bu),
};

const float* GetSrcCoef(uint32_t setNum)
{
    return SrcTab12khz + (4 * setNum);
}

}}  // namespace nns::afx
