﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "BaseScene.h"

class SceneConnected : public BaseScene
{

public :
    SceneConnected(
            ISceneChanger* changer,
            WirelessData* pDistributor
            ) NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT override;
    void Finalize() override;
    void Update() NN_NOEXCEPT override;
    void Draw(
            GraphicsSystem* pGraphicsSystem,
            FontSystem* pFontSystem
            ) NN_NOEXCEPT override;
private :
    void SetDummyTcpSessionInfo() NN_NOEXCEPT;
    void UpdateWowlStats() NN_NOEXCEPT;
    void ClearWowlStats() NN_NOEXCEPT;
    bool ExportStatsToSd() NN_NOEXCEPT;
    static void MonitorThreadFunc(void* arg) NN_NOEXCEPT;
    void UpdatePage1() NN_NOEXCEPT;
    void UpdatePage2() NN_NOEXCEPT;
    void UpdatePage3() NN_NOEXCEPT;
    void DrawConnectState(nn::gfx::util::DebugFontTextWriter& textWriter) NN_NOEXCEPT;
    void DrawPage1(nn::gfx::util::DebugFontTextWriter& textWriter) NN_NOEXCEPT;
    void DrawPage2(nn::gfx::util::DebugFontTextWriter& textWriter) NN_NOEXCEPT;
    void DrawPage3(nn::gfx::util::DebugFontTextWriter& textWriter) NN_NOEXCEPT;
    bool ConnectTcp(const char* cp, uint16_t port) NN_NOEXCEPT;
    void CloseSocket(int fd) NN_NOEXCEPT;
    bool SetTcpSessionInfo(int fd) NN_NOEXCEPT;
private :
    static const int MY_INITIAL_X = INITIAL_X + (FONT_SIZE * 3);
    static const int MY_INITIAL_Y = INITIAL_Y + (FONT_SIZE * 4);
    static const int MAX_PAGE_NUM = 2;
    static const int MAX_ITEM_PAGE2 = 3;
    static const int NUM_OF_IP_CHAR = 12;
    static const int NUM_OF_PORT_CHAR = 5;

    char m_resultStr[30];
    nn::os::Tick m_resultTick;

    nn::os::Tick m_prevTick;
    static int32_t m_rssi;

    nn::wlan::WowlWakeCount  m_wakeCounts;
    nn::wlan::WowlSleepStats m_sleepStats;
    nn::wlan::WlanIpv4Address m_ownIp;

    // 接続状況モニタスレッド
    nn::os::ThreadType m_monitorThread;
    static nn::os::EventType m_event;
    static nn::os::SystemEventType m_connectionEvent;
    static nn::wlan::ConnectionStatus m_connectionStatus;
    static nn::os::MutexType m_mutex;

    int m_pageId;
    int m_page2CurX;
    int m_page2CurY;
    int8_t m_inputIp[NUM_OF_IP_CHAR];
    int8_t m_inputPort[NUM_OF_PORT_CHAR];
    int m_sockFd;
    static bool m_isTcpConnected;
    static int m_recvDataCnt;
    static int m_recvDataSize;
};
