﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

#include "ApplicationHeap.h"
#include "Color.h"
#include "FontSystem.h"
#include "GraphicsSystem.h"
#include "ISceneChanger.h"
#include "Npad.h"
#include "Task.h"
#include "WirelessData.h"

class BaseScene : public Task
{
public:
    // 初期描画位置：X座標
    static const int INITIAL_X = 25;
    // 初期描画位置：Y座標
    static const int INITIAL_Y = 15;
    // フォント拡大率
    static const int FONT_SCALE = 2;
    // フォントサイズ
    static const int FONT_SIZE = 16 * FONT_SCALE;
    // フレームレート
    const int FRAME_RATE = 60;

protected:
    // クラス所有元にシーン切り替えを伝えるインターフェイス
    ISceneChanger* m_SceneChanger;
    // 無線データ共有インターフェイス
    WirelessData* m_distributor;

public :
    BaseScene(
            ISceneChanger* pChanger,
            WirelessData* pDistributor
            ) NN_NOEXCEPT;
    virtual ~BaseScene() NN_NOEXCEPT {}
    virtual void Initialize() NN_NOEXCEPT override {}
    virtual void Finalize() NN_NOEXCEPT override ;
    virtual void Update() NN_NOEXCEPT override {}
    virtual void Draw(
            GraphicsSystem* pGraphicsSystem,
            FontSystem* pFontSystem
            ) NN_NOEXCEPT override;
};
