﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "BaseScene.h"

BaseScene::BaseScene(
        ISceneChanger* pChanger,
        WirelessData* pDistributor
        ) NN_NOEXCEPT
{
    m_SceneChanger = pChanger;
    m_distributor = pDistributor;
}

void BaseScene::Finalize() NN_NOEXCEPT
{
}

void BaseScene::Draw(
        GraphicsSystem* pGraphicsSystem,
        FontSystem* pFontSystem
        ) NN_NOEXCEPT
{
    NN_UNUSED(pGraphicsSystem);
    // 画面表示ヘッダ部
    nn::gfx::util::DebugFontTextWriter&
        textWriter = pFontSystem->GetDebugFontTextWriter();

    const nn::util::Unorm8x4& textColor = Color::White;

    textWriter.SetTextColor( textColor );
    textWriter.SetScale( FONT_SCALE, FONT_SCALE );
    textWriter.SetCursor( INITIAL_X, INITIAL_Y );
    textWriter.Print( "Wowl Field Test Tool" );
    textWriter.SetCursor( INITIAL_X, INITIAL_Y + FONT_SIZE );
    textWriter.Print( "------------------------------------------------------------------------------" );
}
