﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Timer.h"

namespace {

NN_ALIGNAS(4096) char s_TimerStack[4096];

}

namespace WlanTest {

void Sleep(nn::TimeSpan time)
{
    // nn::os::TimerEvent timer(nn::os::EventClearMode_AutoClear);
    // timer.StartOneShot(time);
    // timer.Wait();

    nn::os::SleepThread(time);
}


/*---------------------------------------------------------------------------
　　　　　Timer
---------------------------------------------------------------------------*/

Timer::Timer() : timer(nn::os::EventClearMode_AutoClear)
{
    //timer.Initialize(false);
}

Timer::~Timer()
{
    //timer.Finalize();
    Stop();
}

//static void ThreadFunction(Timer* timer)
void Timer::ThreadFunction(void* arg)
{
    Timer *timer = reinterpret_cast<Timer*>(arg);

    while(!timer->stop)
    {
        if(timer->Interval > nn::TimeSpan::FromSeconds(0))
        {
            timer->timer.Wait();
        }
        if(timer->handler!=NULL && !timer->stop)
        {
            EventArgs a;
            (*timer->handler)(&a);
        }
        if(timer->stopTime != 0 && nn::os::GetSystemTick().ToTimeSpan() > timer->stopTime)
        {
            NN_LOG("TimerHandler Stop.\n");
            break;
        }
    }
}

nn::Result Timer::Start(int32_t priority)
{
    NN_LOG("Timer::Start()\n");
    nn::Result result;

    this->stopTime = 0;
    stop = false;
    if(Interval > nn::TimeSpan::FromSeconds(0))
    {
        timer.StartPeriodic( 0, Interval );
    }

    result = nn::os::CreateThread(&thread, Timer::ThreadFunction, this, s_TimerStack, sizeof(s_TimerStack), priority);
    if( result.IsFailure() )
    {
        NN_LOG("Can not create InvokeThread.\n");
    }
    nn::os::SetThreadNamePointer(&thread, "WitTimerThread");
    nn::os::StartThread(&thread);

    return result;
}

nn::Result Timer::Start(nn::TimeSpan time, int32_t priority)
{
    NN_LOG("Timer::Start()\n");
    nn::Result result;

    this->stopTime = nn::os::GetSystemTick().ToTimeSpan() + time;
    stop = false;
    timer.StartPeriodic( 0, Interval );
    result = nn::os::CreateThread(&thread, Timer::ThreadFunction, this, s_TimerStack, sizeof(s_TimerStack), priority);
    if( result.IsFailure() )
    {

        nn::os::SetThreadNamePointer(&thread, "WitTimerThread");
        NN_LOG("Can not create InvokeThread.\n");
    }
    nn::os::StartThread(&thread);

    return result;
}

void Timer::Stop()
{
    NN_LOG("Timer::Stop()\n");
    stop = true;
    timer.Signal();
    timer.Stop();
    //thread.Join();
    nn::os::WaitThread(&thread);
    //thread.Finalize();
    nn::os::DestroyThread(&thread);
}

}
