﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <map>

#include "TestUtil.h"
#include <cstring>

namespace {

std::map<int, const char*> testInfo;
std::map<int, const char*> roleInfo;

}

namespace WlanTest {

using namespace std;

const char* TEST_NAME_UNDEFINED = "UNDEFINED";
const char* TEST_NAME_H1        = "H1";
const char* TEST_NAME_H2        = "H2";
const char* TEST_NAME_H3        = "H3";
const char* TEST_NAME_H4        = "H4";
const char* TEST_NAME_H5        = "H5";
const char* TEST_NAME_H6        = "H6";
const char* TEST_NAME_C1        = "C1";
const char* TEST_NAME_C2        = "C2";
const char* TEST_NAME_C3        = "C3";
const char* TEST_NAME_MC1       = "MC1";
const char* TEST_NAME_MC2       = "MC2";

const char* ROLE_NAME_UNDEFINED = "UNDEFINED";
const char* ROLE_NAME_MASTER    = "MASTER";
const char* ROLE_NAME_CLIENT    = "CLIENT";
const char* ROLE_NAME_AUDIENCE  = "AUDIENCE";


void InitializeTestInfo()
{
    testInfo[TEST_ID_UNDEFINED] = TEST_NAME_UNDEFINED;
    testInfo[TEST_ID_H1]        = TEST_NAME_H1;
    testInfo[TEST_ID_H2]        = TEST_NAME_H2;
    testInfo[TEST_ID_H3]        = TEST_NAME_H3;
    testInfo[TEST_ID_H4]        = TEST_NAME_H4;
    testInfo[TEST_ID_H5]        = TEST_NAME_H5;
    testInfo[TEST_ID_H6]        = TEST_NAME_H6;
    testInfo[TEST_ID_C1]        = TEST_NAME_C1;
    testInfo[TEST_ID_C2]        = TEST_NAME_C2;
    testInfo[TEST_ID_C3]        = TEST_NAME_C3;
    testInfo[TEST_ID_MC1]       = TEST_NAME_MC1;
    testInfo[TEST_ID_MC2]       = TEST_NAME_MC2;

    roleInfo[ROLE_ID_UNDEFINED] = ROLE_NAME_UNDEFINED;
    roleInfo[ROLE_ID_MASTER]    = ROLE_NAME_MASTER;
    roleInfo[ROLE_ID_CLIENT]    = ROLE_NAME_CLIENT;
    roleInfo[ROLE_ID_AUDIENCE]  = ROLE_NAME_AUDIENCE;
}

int TestName2TestId(const char* name)
{
    if(testInfo.size() == 0 || roleInfo.size() == 0)
    {
        InitializeTestInfo();
    }

    for(std::map<int, const char*>::iterator i=testInfo.begin(); i!=testInfo.end(); ++i)
    {
        if(std::strcmp(i->second, name) == 0)
        {
            return i->first;
        }
    }

    return TEST_ID_UNDEFINED;
}

const char* TestId2TestName(int key)
{
    if(testInfo.size() == 0 || roleInfo.size() == 0)
    {
        InitializeTestInfo();
    }

    if(testInfo.find(key) == testInfo.end())
    {
        return testInfo[TEST_ID_UNDEFINED];
    }

    return testInfo[key];
}

int RoleName2RoleId(const char* name)
{
    if(testInfo.size() == 0 || roleInfo.size() == 0)
    {
        InitializeTestInfo();
    }

    for(std::map<int, const char*>::iterator i=roleInfo.begin(); i!=roleInfo.end(); ++i)
    {
        if(std::strcmp(i->second, name) == 0)
        {
            return i->first;
        }
    }

    return ROLE_ID_UNDEFINED;
}

const char* RoleId2RoleName(int key)
{
    if(testInfo.size() == 0 || roleInfo.size() == 0)
    {
        InitializeTestInfo();
    }

    if(roleInfo.find(key) == roleInfo.end())
    {
        return roleInfo[ROLE_ID_UNDEFINED];
    }

    return roleInfo[key];
}

}
