﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/fs.h>
#include <nn/os.h>

#include <cctype>
#include <cstring>

#include "WlanCommon.h"
#include "Arg.h"
#include "Util.h"
#include "TestUtil.h"

namespace WlanTest {

using namespace std;

WitArg::WitArg()
{
    m_Argc = 0;

    m_TestId = TEST_ID_UNDEFINED;
    m_RoleId = ROLE_ID_UNDEFINED;

    std::memset(m_TestName, 0x00, TEST_NAME_SIZE);
    std::memset(m_RoleName, 0x00, ROLE_NAME_SIZE);
    std::memset(m_InputFile, '\0', INPUT_FILE_NAME_SIZE);
}

WitArg::~WitArg()
{}

void WitArg::Initialize()
{
    m_Argc = nn::os::GetHostArgc();
    char** argv = nn::os::GetHostArgv();

    for(int i=0; i<m_Argc; ++i)
    {
        nn::util::Strlcpy(m_Argv[i], argv[i], WitArg::ARG_STRING_LENGTH_MAX);
    }

    // NN_LOG("argc    : %d\n", m_Argc);
    // for(int i=0; i<m_Argc; ++i)
    // {
    //     NN_LOG("argv[%d] : %s\n", i, m_Argv[i]);
    // }
}

void WitArg::Initialize(int argc, char argv[ARG_SIZE_MAX][ARG_STRING_LENGTH_MAX])
{
    m_Argc = argc;
    for(int i=0; i<m_Argc; ++i)
    {
        nn::util::Strlcpy(m_Argv[i], argv[i], WitArg::ARG_STRING_LENGTH_MAX);
    }

    // NN_LOG("argc    : %d\n", m_Argc);
    // for(int i=0; i<m_Argc; ++i)
    // {
    //     NN_LOG("argv[%d] : %s\n", i, m_Argv[i]);
    // }
}

bool WitArg::Parse()
{
    bool error = false;

    if(m_Argc == 0)
    {
        return false;
    }

    for(int i=1; i<m_Argc && !error; ++i)
    {
        NN_LOG("%s ", m_Argv[i]);

        if(std::strcmp(m_Argv[i], "--auto") == 0 || std::strcmp(m_Argv[i], "--a") == 0)
        {
            ++i;
            if(m_Argc > i)
            {
                const int size = 64;
                char testName[size];
                if(std::strlen(m_Argv[i]) > size)
                {
                    NN_LOG("  - failed : Too long test name\n");
                    NN_LOG("           : %s\n", m_Argv[i]);
                    error = true;
                    break;
                }

                nn::util::Strlcpy(testName, m_Argv[i], size);
                ToUpper(testName, std::strlen(testName));
                m_TestId = TestName2TestId(testName);

                if(m_TestId == TEST_ID_UNDEFINED)
                {
                    NN_LOG("  - failed : Unknown test name %s\n", m_Argv[i]);
                    error = true;
                }

                NN_LOG("%s(%d)\n", TestId2TestName(m_TestId), m_TestId);
            }
            else
            {
                NN_LOG("  - failed : No test name\n");
                error = true;
            }
        }
        else if(std::strcmp(m_Argv[i], "--role") == 0 || std::strcmp(m_Argv[i], "--r") == 0)
        {
            ++i;
            if(m_Argc > i)
            {
                const int size = 64;
                char roleName[size];
                if(std::strlen(m_Argv[i]) > size)
                {
                    NN_LOG("  - failed : Too long role name\n");
                    NN_LOG("           : %s\n", m_Argv[i]);
                    error = true;
                    break;
                }

                std::strcpy(roleName, m_Argv[i]);
                ToUpper(roleName, std::strlen(roleName));
                m_RoleId = RoleName2RoleId(roleName);

                if(m_RoleId == ROLE_ID_UNDEFINED)
                {
                    NN_LOG("  - failed : Unknown role name %s\n", m_Argv[i]);
                    error = true;
                }

                NN_LOG("%s(%d)\n", RoleId2RoleName(m_RoleId), m_RoleId);
            }
            else
            {
                NN_LOG("  - failed : No role\n");
                error = true;
            }
        }
        else if(std::strcmp(m_Argv[i], "--input") == 0 || std::strcmp(m_Argv[i], "--i") == 0)
        {
            ++i;
            if(m_Argc > i)
            {
                static const size_t BufferSize = 4096;
                static uint8_t readBuffer[BufferSize];
                NN_LOG("File path : %s\n", m_Argv[i]);

                // リードできるかの確認
                if(ReadFile(reinterpret_cast<uint8_t*>(readBuffer), sizeof(readBuffer), m_Argv[i]))
                {
                    nn::util::Strlcpy(m_InputFile, m_Argv[i], INPUT_FILE_NAME_SIZE);
                }
                else
                {
                    error = true;
                }
            }
            else
            {
                NN_LOG("  - failed : No input file\n");
                error = true;
            }
        }
        // else if(std::strcmp(m_Argv[i], "--output") == 0 || std::strcmp(m_Argv[i], "--o") == 0)
        // {
        //     ++i;
        //     if(m_Argc > i)
        //     {
        //     }
        //     else
        //     {
        //         NN_LOG("  - failed : No output file\n");
        //         error = true;
        //     }
        // }
        else
        {
            NN_LOG("Unknow option : %s\n", m_Argv[i]);
            error = true;
        }
    }
    NN_LOG("\n");

    NN_LOG(" Loading file completed : %s\n", (error ? "failure..." : "success!"));

    return !error;
} //NOLINT(impl/function_size)

}
