﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/wlan/wlan_MacAddress.h>
#include <nn/wlan/wlan_Types.h>

namespace WlanTest {

const uint32_t  WIT_VERSION_MAJOR = 1;
const uint32_t  WIT_VERSION_MINOR = 3;
const uint32_t  WIT_VERSION_MICRO = 2;
extern const char* WIT_VERSION_SUFFIX;
extern const char* INPUT_FILE_PATH_FOR_ARG;

// bluetooth

const uint32_t TSI_MAX = 10;
const uint32_t REMOTE_COUNT_MAX = 8;
const uint32_t REMOTE_PAIR_COUNT_MAX = (REMOTE_COUNT_MAX >> 1);

extern const char* DEVICE_TYPE_UKYO_NAME;
extern const char* DEVICE_TYPE_SAKYO_NAME;

// wlan

extern const uint8_t OUI[3];
extern const uint8_t PID_LDN[2];
const size_t WEP64_ASCII_KEY_SIZE  = 5;
const size_t WEP128_ASCII_KEY_SIZE = 13;
const int32_t RSSI_MAX = 0;
const int32_t RSSI_MIN = -128;
const int     ConnectableClientCount_Any = 0;
const int     ConnectableNodeCountMax = nn::wlan::ConnectableClientsCountMax;
const uint8_t DhpMajor = 1;  // Major version
const uint8_t DhpMinor = 0;  // Miner version
const uint8_t DhpCmdPeriodic = 0x01;
const uint8_t DhpCmdOneShot = 0x02;


// socket

const uint32_t PORT_NUMBER_MAX = 65535;
extern const char* BROADCAST_IP_ADDRESS;
extern const char* SOCKET_TYPE_UNKNOWN_STR;
extern const char* SOCKET_TYPE_TCP_STR;
extern const char* SOCKET_TYPE_UDP_STR;
extern const char* PACKET_FORMAT_WIT_STR;
extern const char* PACKET_FORMAT_RTP_STR;

// display

const uint32_t DISPLAY_TITLE_START_X   = 10;
const uint32_t DISPLAY_TITLE_START_Y   = 70;
const uint32_t DISPLAY_CONTENT_START_X = 30;
const uint32_t DISPLAY_CONTENT_START_Y = 110;
const uint32_t DISPLAY_PAD_START_X     = 15;
const uint32_t DISPLAY_PAD_START_Y     = 680;

const float DEFAULT_FIXED_WIDTH        = 20;
const float DEFAULT_FONT_WIDTH         = 24;
const float DEFAULT_FONT_HEIGHT        = 30;
const uint32_t DISPLAY_CONTENT_HEIGHT  = DISPLAY_PAD_START_Y - DISPLAY_CONTENT_START_Y - 20;
extern const char* DISPLAY_SEPARATOR;
extern const char* PAD_TEXT_SEPARATOR;

const nn::TimeSpan InfinityTime = nn::TimeSpan::FromDays(1000);


/*!
 * @brief 受信フレームのプロトコルIDを示す列挙体です。
 */
enum ProtocolId
{
    PID_IPV4         = 0x0800,   //!< IPv4
    PID_ARP          = 0x0806,   //!< ARP
    PID_EAPOL        = 0x888E,   //!< EAPOL
    PID_LOCAL_EXP1   = 0x88B5,   //!< Local Experimental Ethernet
    PID_LOCAL_EXP2   = 0x88B6,   //!< Local Experimental Ethernet
    PID_OUI_EXT      = 0x88B7,   //!< OUI_EXTENDED_ETHERTYPE
    PID_PAYLOAD_ONLY = 0xFFFF    //!< For infra communication
    // TODO: IPv6のプロトコルを追加する必要有り?
};

enum SocketType
{
    SOCKET_TYPE_UNKNOWN = 0,
    SOCKET_TYPE_TCP,
    SOCKET_TYPE_UDP
};

enum PacketFormat
{
    PACKET_FORMAT_UNKNOWN = 0,
    PACKET_FORMAT_WIT,
    PACKET_FORMAT_RTP,
};

enum Button
{
    START = 0,
    SELECT,
    A,
    B,
    X,
    Y,
    L,
    R,
    ZL,
    ZR,
    LEFT,
    UP,
    RIGHT,
    DOWN,
    SL,       // stick left emulation
    SL_LEFT,
    SL_UP,
    SL_RIGHT,
    SL_DOWN,
    SR,      // stick right emulation
    SR_LEFT,
    SR_UP,
    SR_RIGHT,
    SR_DOWN,
    MINUS,
    PLUS
};

struct ActionFrameParams
{
    // AF のペイロード長 (byte)
    uint32_t  payloadSize;

    // AF の送信回数
    uint8_t   count;

    // AF を送信するチャネルとその数 (channelCount は 1 以上)
    int16_t   channelList[nn::wlan::WirelessChannelsCountMax];
    uint8_t   channelCount;

    // 初回送信までの固定待ち時間
    nn::TimeSpan  waitTime;

    // 初回送信までのランダム待ち時間の最大 (ms)
    uint32_t  maxRandomWaitTime;

    // 2回目送信以降の間隔
    nn::TimeSpan  interval;
};

class MacAddressCompare{
public:
    bool operator()(const nn::wlan::MacAddress &left, const nn::wlan::MacAddress &right) const
    {
        for(int i=0; i<nn::wlan::MacAddress::MacAddressSize; ++i)
        {
            uint8_t lValue = left.GetMacAddressData()[i];
            uint8_t rValue = right.GetMacAddressData()[i];
            if(lValue != rValue)
            {
                return lValue < rValue;
            }
        }
        return false;
    }
};


}
