﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <string>

#include <nn/wlan/wlan_Types.h>
#include <nn/btm/btm.h>

#include "WlanTestTypes.h"

#if 0

#define DBG_LOG()                                                       \
    do{                                                                 \
        {                                                               \
            NN_LOG("    ### %s  %s()  @%d\n", __FILE__, __FUNCTION__, __LINE__); \
        }                                                               \
    }                                                                   \
    while(0);

#define DBG_VLOG(str)                                                   \
    do{                                                                 \
        {                                                               \
            NN_LOG("    ### %s  - %s  %s()  @%d\n", str, __FILE__, __FUNCTION__, __LINE__); \
        }                                                               \
    }                                                                   \
    while(0);

#else

#define DBG_LOG()
#define DBG_VLOG(str)

#endif


namespace WlanTest {

using namespace std;

enum TimeUnit
{
    TIME_UNIT_NANO_SECONDS = 0,
    TIME_UNIT_MICRO_SECONDS,
    TIME_UNIT_MILLI_SECONDS,
    TIME_UNIT_SECONDS,
    TIME_UNIT_MINUTES,
    TIME_UNIT_HOURS,
    TIME_UNIT_DAYS
};

enum CaseOption
{
    CASE_OPTION_UPPER = 0,
    CASE_OPTION_LOWER,
    CASE_OPTION_PROPER
};

enum TimeFormat
{
    TimeFormat_Alphabet = 0,
    TimeFormat_Colon
};

void TPrintResult(nn::Result result);

template< class T > inline T* AlignedNew( int alignment )
{
    void* p = aligned_alloc( sizeof(T), alignment );
    new(p) T();
    return reinterpret_cast<T*>(p);
}

void AlignedDelete( void* p );

bool ReadFile(uint8_t out[], uint32_t outSize, const char* path);

void ToUpper(char* str, int size);
void ToLower(char* str, int size);
string ToUpper(const string& s);
string ToLower(const string& s);

string Trim(const string& s, const char* charList = " \t");

string ToString(const nn::TimeSpan& timespan, const TimeUnit& fillFrom = TIME_UNIT_SECONDS, const TimeFormat& format = TimeFormat_Alphabet);
string ToString(const nn::wlan::SecurityMode& mode);
string ToString(const nn::wlan::MacAddress& addr);
string ToString(const nn::wlan::DetectHash& hash);
string ToString(const nn::btm::BdAddress& bdaddr);
string ToString(const nn::btm::BluetoothMode& btMode, const nn::btm::WlanMode& wlMode);
string ToString(const nn::btm::WlanMode& mode);
string ToString(const nn::btm::SniffMode& mode);
string ToString(const nn::btm::SlotMode& mode);
string ToString(const Button& button);
string ToStringSimpleTimeSpan(const nn::TimeSpan& timespan);
string ToStringForBinaryPrefix(const double& v, const string& separator = " ", const int8_t precision = 0);
string ToStringForDecimalPrefix(const double& v, const string& separator = " ", const int8_t precision = 0);
string ToStringTrueFalse(const int32_t& v, const CaseOption option = CASE_OPTION_UPPER);
string ToStringOnOff(const int32_t& v, const CaseOption option = CASE_OPTION_UPPER);
string ToStringYesNo(const int32_t& v, const CaseOption option = CASE_OPTION_UPPER);
string ToStringSocketType(const SocketType& type);
string ToStringPacketFormat(const PacketFormat& format);

uint64_t ToUint(const nn::wlan::MacAddress& macAddress);
uint64_t ToUint(const nn::wlan::DetectHash& hash);

bool GenerateTimeSpan(nn::TimeSpan& timeSpan, const int64_t& value, const char& unit);
bool GenerateTimeSpan(nn::TimeSpan& timeSpan, const int64_t& value, const TimeUnit& unit);
bool GenerateByteScale(uint32_t& scale, const uint32_t& value, const char& unit);

string ConvertWordCase(const string& from, const CaseOption option);
string PackString(const string& from, uint32_t width, uint32_t height);
string DuplicateEscapeSequence(const string& from, const string& escapeCodes);
int Count(const string& text, const char c);

enum ThroughputUnit
{
    ThroughputUnit_Bps,
    ThroughputUnit_Kbps,
    ThroughputUnit_Mbps,
};
double CalculateThroughput(uint64_t sizeByte, int64_t timeMs, ThroughputUnit unit = ThroughputUnit_Mbps);
double CalculateThroughput(uint64_t sizeByte, nn::os::Tick start, nn::os::Tick end, ThroughputUnit unit = ThroughputUnit_Mbps);

string GetMacAddressStr(const string& separator = ":");
string GetTodayStr();

bool operator!=(const nn::btm::BdAddress& address1, const nn::btm::BdAddress& address2);
ostream& operator<<(ostream& stream, const nn::bluetooth::Btbdaddr& address);

bool operator==(const nn::wlan::DetectHash& hash1, const nn::wlan::DetectHash& hash2);
bool operator!=(const nn::wlan::DetectHash& hash1, const nn::wlan::DetectHash& hash2);

// wlan

bool ConvertWepKey(string* to, const string& from, const nn::wlan::SecurityMode mode);
nn::Result GetTsfTime(int64_t* pTime);

}
