﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <sstream>

using namespace std;

namespace WlanTest {

class TextWriter {

public:

    TextWriter(){};
    virtual ~TextWriter(){};

    //! 文字列を書き込みます
    virtual bool Write(const string&) = 0;

    //! 文字列を行として書き込みます
    virtual bool WriteLine(const string& str)
    {
        string line = str + "\n";
        return Write(line);
    }

private:
};


class TextWriterDecorator : public TextWriter
{
/*---------------------------------------------------------------------------
　　　　　メンバ変数
---------------------------------------------------------------------------*/
public:
protected:
    WlanTest::TextWriter* m_Writer;
private:

/*---------------------------------------------------------------------------
　　　　　メンバメソッド
---------------------------------------------------------------------------*/
public:

    //! 文字列を書き込みます
    virtual bool Write(const string& str);

/*---------------------------------------------------------------------------
　　　　　コンストラクタ類
---------------------------------------------------------------------------*/
public:

    NN_IMPLICIT TextWriterDecorator(TextWriter& writer);
    virtual ~TextWriterDecorator();

private:

};


class TimeWriter : public TextWriterDecorator
{
/*---------------------------------------------------------------------------
　　　　　メンバ変数
---------------------------------------------------------------------------*/
public:
protected:
private:

    nn::os::Tick m_Start;
    bool m_NeedWriteTime;

/*---------------------------------------------------------------------------
　　　　　メンバメソッド
---------------------------------------------------------------------------*/
public:

    //! 文字列を書き込みます
    virtual bool Write(const string& str);
    virtual void Reset();

/*---------------------------------------------------------------------------
　　　　　コンストラクタ類
---------------------------------------------------------------------------*/
public:

    NN_IMPLICIT TimeWriter(TextWriter& writer);
    virtual ~TimeWriter();
};



}    // WlanTest
