﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <sstream>
#include <iomanip>
#include <cmath>
#include <deque>
#include "Node.h"

namespace WlanTest {

typedef std::deque<Rssi> RssiHistory;

class RssiStatistics
{

private:
protected:

    bool m_IsStop;
    uint32_t m_RecordInterval; // msec
    uint32_t m_RecordCount;
    Node* m_pNode;
    vector<RssiHistory> m_Statistics;
    nn::os::Mutex      m_Cs;
    nn::os::ThreadType m_RecordRssiThread;

public:

private:

    int32_t FindOldestIndex();

protected:

    static void RecordRssiThreadFunc(void* pRssiStatistics);
    void RecordRssi();

public:

    RssiStatistics();
    virtual ~RssiStatistics();

    void Clear();
    nn::Result StartRecordRssi(int32_t priority = nn::os::GetThreadCurrentPriority(nn::os::GetCurrentThread()));
    void StopRecordRssi();
    bool IsStop();

    const vector<RssiHistory>& GetStatistics();
    void SetNode(Node* pNode);
    void SetRecordInterval(uint32_t msec);
    uint32_t GetRecordInterval();
    void SetRecordCount(uint32_t coung);
    uint32_t GetRecordCount();
};

}
