﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdio>
#include <nn/os.h>

#include "ConfigurationMenu.h"
#include "Display.h"
#include "Pad.h"
#include "Master.h"
#include "Client.h"
#include "ModelController.h"
#include "ModelViewer.h"
#include "TextWriter.h"
#include "UIControl.h"
#include "Timer.h"
#include "TestUtil.h"
#include "Test.h"

namespace WlanTest {

/*---------------------------------------------------------------------------
  Program
---------------------------------------------------------------------------*/
class Program
{
protected:
public:

    Program(){}
    virtual ~Program(){}
    virtual void Execute(){}
    virtual void Exit(){}

};


/*---------------------------------------------------------------------------
  Application
---------------------------------------------------------------------------*/
class Application : public Program
{
private:
protected:

    bool m_NeedExit;
    virtual void ApplicationImpl(){}
    virtual void Initialize(){}
    virtual void Finalize(){}
    void HandleSystemNotifications();

public:

    Application();
    virtual ~Application();

    virtual void Execute();
    virtual void Exit();

    static bool IsWlanFlightModeEnabled();
    static void SetWlanFlightMode(bool isEnabled);

    static bool IsBtFlightModeEnabled();
    static void SetBtFlightMode(bool isEnabled);
};


/*---------------------------------------------------------------------------
  TestSelector
---------------------------------------------------------------------------*/
class TestSelector : public Application
{
private :
    bool                     m_Selected;

    Page                     m_InfoPage;
    Label                    m_Separator[2];
    Label                    m_BlankLine;
    Label                    m_Path;

    ConfigurationPage        m_ConfigPage;
    Page                     m_Page;
    Label                    m_A;
    Label                    m_Title;
    Selector<Test>           m_Selector;

    LocalMasterTest*         m_pLocalMasterTest;
    LocalClientTest*         m_pLocalClientTest;
    LcsMasterTest*           m_pLcsMasterTest;
    LcsClientTest*           m_pLcsClientTest;
    InfraTest*               m_pInfraTest;
    HostDrivenDetectorTest*  m_pHostDrivenDetectorTest;
    ScanTest*                m_pLocalScanTest;
    ScanTest*                m_pInfraScanTest;
    RcViewer*                m_pRcViewer;

    WlanFwInfo               m_WlanFwInfo;

private :

    void InitializeInfoPage();

public :
    TestSelector();
    virtual ~TestSelector();
    virtual void ApplicationImpl();
};


/*---------------------------------------------------------------------------
  TestConductor
---------------------------------------------------------------------------*/
class TestConductor : public Application
{
private :

    Test*              m_pTest;

private :

    void InitializeInfoPage();

public :
    NN_IMPLICIT TestConductor(Test* pTest);
    virtual ~TestConductor();
    virtual void ApplicationImpl();

    // void Initialize( id, Role role);
    // void SetParams();

};


} // WlanTest
